/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.TransactionalProtocolOperationHandler;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.mgmt.domain.HostControllerServerConnection;
import org.jboss.as.server.mgmt.domain.RemoteFileRepository;
import org.jboss.as.server.mgmt.domain.ServerToHostRemoteFileRequestAndHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.threads.JBossThreadFactory;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;

public class HostControllerServerClient
implements Service<HostControllerServerClient> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "client"});
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private final InjectedValue<ModelController> controller = new InjectedValue();
    private final InjectedValue<RemoteFileRepository> remoteFileRepositoryValue = new InjectedValue();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final int port;
    private final String hostName;
    private final String serverName;
    private final String userName;
    private final String serverProcessName;
    private final byte[] authKey;
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("host-controller-connection-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
    private final ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);
    private ManagementChannelAssociation handler;
    private HostControllerServerConnection connection;

    public HostControllerServerClient(String serverName, String serverProcessName, String host, int port, byte[] authKey) {
        this.serverName = serverName;
        this.userName = "=" + serverName;
        this.hostName = host;
        this.port = port;
        this.serverProcessName = serverProcessName;
        this.authKey = authKey;
    }

    public synchronized void start(final StartContext context) throws StartException {
        final ModelController controller = (ModelController)this.controller.getValue();
        context.asynchronous();
        try {
            ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
            configuration.setEndpoint((Endpoint)this.endpointInjector.getValue());
            configuration.setConnectionTimeout(15000L);
            configuration.setUri(new URI("remote://" + this.hostName + ":" + this.port));
            OptionMap original = configuration.getOptionMap();
            OptionMap.Builder builder = OptionMap.builder();
            builder.addAll(original);
            builder.set(Options.SASL_DISALLOWED_MECHANISMS, (Object)Sequence.of((Object[])new String[]{JBOSS_LOCAL_USER}));
            configuration.setOptionMap(builder.getMap());
            ClientCallbackHandler callbackHandler = new ClientCallbackHandler(this.userName, this.authKey);
            this.connection = new HostControllerServerConnection(this.serverProcessName, configuration, this.executor);
            this.connection.connect(callbackHandler, new ActiveOperation.CompletedCallback<Void>(){

                public void completed(Void result) {
                    ManagementChannelHandler handler = HostControllerServerClient.this.connection.getChannelHandler();
                    handler.addHandlerFactory((ManagementRequestHandlerFactory)new TransactionalProtocolOperationHandler(controller, (ManagementChannelAssociation)handler));
                    ((RemoteFileRepository)HostControllerServerClient.this.remoteFileRepositoryValue.getValue()).setRemoteFileRepositoryExecutor(new RemoteFileRepositoryExecutorImpl());
                    context.complete();
                    HostControllerServerClient.this.started();
                }

                public void failed(Exception e) {
                    context.failed(ServerMessages.MESSAGES.failedToConnectToHC(e));
                }

                public void cancelled() {
                    context.failed(ServerMessages.MESSAGES.cancelledHCConnect());
                }
            });
            this.handler = this.connection.getChannelHandler();
        }
        catch (Exception e) {
            throw ServerMessages.MESSAGES.failedToConnectToHC(e);
        }
    }

    public synchronized void stop(StopContext context) {
        StreamUtils.safeClose((Closeable)((Object)this.connection));
    }

    public synchronized void reconnect(String host, int port, byte[] authKey) throws Exception {
        HostControllerServerConnection connection = this.connection;
        URI uri = new URI("remote://" + host + ":" + port);
        ClientCallbackHandler callbackHandler = new ClientCallbackHandler(this.userName, authKey);
        connection.reconnect(uri, callbackHandler, new ActiveOperation.CompletedCallback<Boolean>(){

            public void completed(Boolean inSync) {
                if (!inSync.booleanValue()) {
                    HostControllerServerClient.this.requireRestart();
                }
            }

            public void failed(Exception e) {
            }

            public void cancelled() {
            }
        });
    }

    private synchronized void requireRestart() {
        ModelController controller = (ModelController)this.controller.getValue();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("server-set-restart-required");
        operation.get("address").setEmptyList();
        controller.execute(operation, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, OperationAttachments.EMPTY);
    }

    public String getServerName() {
        return this.serverName;
    }

    public synchronized void started() {
        ManagementChannelAssociation handler = this.handler;
        try {
            handler.executeRequest((ManagementRequest)new ServerStartedRequest(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized HostControllerServerClient getValue() throws IllegalStateException {
        return this;
    }

    public Injector<ModelController> getServerControllerInjector() {
        return this.controller;
    }

    public Injector<RemoteFileRepository> getRemoteFileRepositoryInjector() {
        return this.remoteFileRepositoryValue;
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointInjector;
    }

    private static class ClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final byte[] authKey;

        private ClientCallbackHandler(String userName, byte[] authKey) {
            this.userName = userName;
            this.authKey = authKey;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.userName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(new String(this.authKey).toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }

    private class RemoteFileRepositoryExecutorImpl
    implements RemoteFileRepository.RemoteFileRepositoryExecutor {
        private RemoteFileRepositoryExecutorImpl() {
        }

        @Override
        public File getFile(String relativePath, byte repoId, File localDeploymentFolder) {
            try {
                return (File)HostControllerServerClient.this.handler.executeRequest((ManagementRequest)new GetFileRequest(relativePath, localDeploymentFolder), null).getResult().get();
            }
            catch (Exception e) {
                throw ServerMessages.MESSAGES.failedToGetFileFromRemoteRepository(e);
            }
        }
    }

    private static class GetFileRequest
    extends AbstractManagementRequest<File, Void> {
        private final String hash;
        private final File localDeploymentFolder;

        private GetFileRequest(String hash, File localDeploymentFolder) {
            this.hash = hash;
            this.localDeploymentFolder = localDeploymentFolder;
        }

        public byte getOperationType() {
            return 36;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            ServerToHostRemoteFileRequestAndHandler.INSTANCE.sendRequest(output, (byte)0, this.hash);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            try {
                File first = new File(this.localDeploymentFolder, this.hash.substring(0, 2));
                File localPath = new File(first, this.hash.substring(2));
                ServerToHostRemoteFileRequestAndHandler.INSTANCE.handleResponse(input, localPath, ServerLogger.ROOT_LOGGER, resultHandler, context);
                resultHandler.done(null);
            }
            catch (RemoteFileRequestAndHandler.CannotCreateLocalDirectoryException e) {
                resultHandler.failed((Exception)ServerMessages.MESSAGES.cannotCreateLocalDirectory(e.getDir()));
            }
            catch (RemoteFileRequestAndHandler.DidNotReadEntireFileException e) {
                resultHandler.failed((Exception)ServerMessages.MESSAGES.didNotReadEntireFile(e.getMissing()));
            }
        }
    }

    public class ServerStartedRequest
    extends AbstractManagementRequest<Void, Void> {
        private final String message = "";

        public byte getOperationType() {
            return 2;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(33);
            output.writeUTF("");
            resultHandler.done(null);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
        }
    }
}

