/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Test;

public abstract class AbstractSubsystemBaseTest
extends AbstractSubsystemTest {
    public AbstractSubsystemBaseTest(String mainSubsystemName, Extension mainExtension) {
        super(mainSubsystemName, mainExtension);
    }

    protected abstract String getSubsystemXml() throws IOException;

    protected String getSubsystemXml(String configId) throws IOException {
        return this.readResource(configId);
    }

    @Test
    public void testSubsystem() throws Exception {
        this.standardSubsystemTest(null);
    }

    protected void standardSubsystemTest(String configId) throws Exception {
        this.standardSubsystemTest(configId, true);
    }

    protected void standardSubsystemTest(String configId, boolean compareXml) throws Exception {
        AdditionalInitialization additionalInit = this.createAdditionalInitialization();
        String subsystemXml = configId == null ? this.getSubsystemXml() : this.getSubsystemXml(configId);
        KernelServices servicesA = super.installInController(additionalInit, subsystemXml);
        Assert.assertNotNull((Object)servicesA);
        ModelNode modelA = servicesA.readWholeModel();
        this.validateModel(modelA);
        String marshalled = servicesA.getPersistedSubsystemXml();
        servicesA.shutdown();
        String normalizedSubsystem = this.normalizeXML(subsystemXml);
        if (compareXml) {
            this.compareXml(configId, normalizedSubsystem, this.normalizeXML(marshalled));
        }
        KernelServices servicesB = super.installInController(additionalInit, marshalled);
        ModelNode modelB = servicesB.readWholeModel();
        this.compare(modelA, modelB);
        ModelNode operation = this.createDescribeOperation();
        ModelNode result = servicesB.executeOperation(operation);
        Assert.assertTrue((String)"the subsystem describe operation has to generate a list of operations to recreate the subsystem", (!result.hasDefined("failure-description") ? 1 : 0) != 0);
        List operations = result.get("result").asList();
        servicesB.shutdown();
        KernelServices servicesC = super.installInController(additionalInit, operations);
        ModelNode modelC = servicesC.readWholeModel();
        this.compare(modelA, modelC);
        this.assertRemoveSubsystemResources(servicesA, this.getIgnoredChildResourcesForRemovalTest());
    }

    protected void validateModel(ModelNode model) {
        Assert.assertNotNull((Object)model);
    }

    protected ModelNode createDescribeOperation() {
        ModelNode address = new ModelNode();
        address.add("subsystem", this.getMainSubsystemName());
        ModelNode operation = new ModelNode();
        operation.get("operation").set("describe");
        operation.get("address").set(address);
        return operation;
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return AdditionalInitialization.MANAGEMENT;
    }

    protected Set<PathAddress> getIgnoredChildResourcesForRemovalTest() {
        return Collections.emptySet();
    }

    protected void testConverter(ModelNode expected, int major, int minor) throws Exception {
        KernelServices service = super.installInController(AdditionalInitialization.MANAGEMENT, this.getSubsystemXml());
        ModelNode transformed = service.readTransformedModel(major, minor).get(new String[]{"subsystem", this.mainSubsystemName});
        this.compare(expected, transformed);
    }
}

