/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;

class StringConfigurationPersister
extends AbstractConfigurationPersister {
    private final List<ModelNode> bootOperations;
    volatile String marshalled;

    public StringConfigurationPersister(List<ModelNode> bootOperations, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        super(rootDeparser);
        this.bootOperations = bootOperations;
    }

    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        return new StringPersistenceResource(model, this);
    }

    public List<ModelNode> load() throws ConfigurationPersistenceException {
        return this.bootOperations;
    }

    List<ModelNode> getBootOperations() {
        return this.bootOperations;
    }

    String getMarshalled() {
        return this.marshalled;
    }

    private class StringPersistenceResource
    implements ConfigurationPersister.PersistenceResource {
        private byte[] bytes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StringPersistenceResource(ModelNode model, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
            ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
            try {
                try {
                    persister.marshallAsXml(model, (OutputStream)output);
                }
                finally {
                    try {
                        output.close();
                    }
                    catch (Exception ignore) {}
                    this.bytes = output.toByteArray();
                }
            }
            catch (Exception e) {
                throw new ConfigurationPersistenceException("Failed to marshal configuration", (Throwable)e);
            }
        }

        public void commit() {
            StringConfigurationPersister.this.marshalled = new String(this.bytes);
        }

        public void rollback() {
            StringConfigurationPersister.this.marshalled = null;
        }
    }
}

