/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBean;

public class ServiceMBeanSupport
implements ServiceMBean,
MBeanRegistration {
    protected Logger log;
    protected MBeanServer server;
    protected ObjectName serviceName;
    private int state = 7;
    private boolean createIgnored = false;
    private boolean startIgnored = false;
    private boolean stopIgnored = false;
    private boolean destroyIgnored = false;
    private boolean unregisterIgnored = false;

    public ServiceMBeanSupport() {
        this.log = Logger.getLogger((String)this.getClass().getName());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Constructing");
        }
    }

    public ServiceMBeanSupport(Class<?> type) {
        this(type.getName());
    }

    public ServiceMBeanSupport(String category) {
        this(Logger.getLogger((String)category));
    }

    public ServiceMBeanSupport(Logger log) {
        this.log = log;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Constructing");
        }
    }

    @Override
    public String getName() {
        String s = this.log.getName();
        int i = s.lastIndexOf(".");
        return i != -1 ? s.substring(i + 1, s.length()) : s;
    }

    public ObjectName getServiceName() {
        return this.serviceName;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public String getStateString() {
        return states[this.state];
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public void create() throws Exception {
        this.jbossInternalCreate();
    }

    @Override
    public void start() throws Exception {
        this.jbossInternalStart();
    }

    @Override
    public void stop() {
        try {
            this.jbossInternalStop();
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in stop " + this.jbossInternalDescription()), t);
        }
    }

    @Override
    public void destroy() {
        try {
            this.jbossInternalDestroy();
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in destroy " + this.jbossInternalDescription()), t);
        }
    }

    protected String jbossInternalDescription() {
        if (this.serviceName != null) {
            return this.serviceName.toString();
        }
        return this.getName();
    }

    @Override
    public void jbossInternalLifecycle(String method) throws Exception {
        if (method == null) {
            throw new IllegalArgumentException("Null method name");
        }
        if (method.equals("create")) {
            this.jbossInternalCreate();
        } else if (method.equals("start")) {
            this.jbossInternalStart();
        } else if (method.equals("stop")) {
            this.jbossInternalStop();
        } else if (method.equals("destroy")) {
            this.jbossInternalDestroy();
        } else {
            throw new IllegalArgumentException("Unknown lifecyle method " + method);
        }
    }

    protected void jbossInternalCreate() throws Exception {
        if (this.state != 8) {
            this.createIgnored = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring create call; current state is " + this.getStateString()));
            }
            return;
        }
        this.createIgnored = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating " + this.jbossInternalDescription()));
        }
        try {
            this.createService();
            this.state = 6;
        }
        catch (Exception e) {
            this.log.warn((Object)("Initialization failed " + this.jbossInternalDescription()), (Throwable)e);
            throw e;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created " + this.jbossInternalDescription()));
        }
        if (this.startIgnored) {
            this.start();
        }
    }

    protected void jbossInternalStart() throws Exception {
        if (this.state != 6 && this.state != 0) {
            this.startIgnored = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring start call; current state is " + this.getStateString()));
            }
            return;
        }
        this.startIgnored = false;
        this.state = 2;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Starting " + this.jbossInternalDescription()));
        }
        try {
            this.startService();
        }
        catch (Exception e) {
            this.state = 4;
            this.log.warn((Object)("Starting failed " + this.jbossInternalDescription()), (Throwable)e);
            throw e;
        }
        this.state = 3;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Started " + this.jbossInternalDescription()));
        }
        if (this.stopIgnored) {
            this.stop();
        }
    }

    protected void jbossInternalStop() {
        if (this.state != 3) {
            this.stopIgnored = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring stop call; current state is " + this.getStateString()));
            }
            return;
        }
        this.stopIgnored = false;
        this.state = 1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping " + this.jbossInternalDescription()));
        }
        try {
            this.stopService();
        }
        catch (Throwable e) {
            this.state = 4;
            this.log.warn((Object)("Stopping failed " + this.jbossInternalDescription()), e);
            return;
        }
        this.state = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopped " + this.jbossInternalDescription()));
        }
        if (this.destroyIgnored) {
            this.destroy();
        }
    }

    protected void jbossInternalDestroy() {
        if (this.state != 0) {
            this.destroyIgnored = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring destroy call; current state is " + this.getStateString()));
            }
            return;
        }
        this.destroyIgnored = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying " + this.jbossInternalDescription()));
        }
        try {
            this.destroyService();
        }
        catch (Throwable t) {
            this.log.warn((Object)("Destroying failed " + this.jbossInternalDescription()), t);
        }
        this.state = 5;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroyed " + this.jbossInternalDescription()));
        }
        if (this.unregisterIgnored) {
            this.postDeregister();
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.serviceName = this.getObjectName(server, name);
        return this.serviceName;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Registration is not done -> stop");
            }
            this.stop();
        } else {
            this.state = 8;
            if (this.createIgnored) {
                try {
                    this.create();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        if (this.state != 5) {
            this.unregisterIgnored = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring postDeregister call; current state is " + this.getStateString()));
            }
            return;
        }
        this.unregisterIgnored = false;
        this.server = null;
        this.serviceName = null;
        this.state = 7;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name;
    }

    protected void createService() throws Exception {
    }

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() throws Exception {
    }
}

