/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.as.test.integration.management.util.CLIException;
import org.jboss.as.test.integration.management.util.CLIOpResult;

public class CLIWrapper
implements Runnable {
    private static String cliCommand = null;
    private static final String outThreadHame = "CLI-out";
    private static final String errThreadHame = "CLI-err";
    private Process cliProcess;
    private PrintWriter writer;
    private BufferedReader outputReader;
    private BufferedReader errorReader;
    private BlockingQueue<String> outputQueue = new LinkedBlockingQueue<String>();

    public CLIWrapper() throws Exception {
        this(false);
    }

    public CLIWrapper(boolean connect) throws Exception {
        this.init();
        if (!connect) {
            return;
        }
        String line = this.readLine(10000L);
        while (!line.contains("You are disconnected")) {
            line = this.readLine(10000L);
        }
        this.sendLine("connect", false);
        line = this.readLine(5000L);
        if (line.indexOf("disconnected") < 0) {
            throw new CLIException("Disconnect check failed. Line received: " + line);
        }
        this.sendLine("version", false);
        line = this.readLine(5000L);
        if (line.indexOf("[standalone@") < 0) {
            throw new CLIException("Connect failed. Line received: " + line);
        }
    }

    public void sendLine(String line, boolean waitForEcho) throws Exception {
        System.out.println("[CLI-inp] " + line);
        this.writer.println(line);
        this.writer.flush();
        if (!waitForEcho) {
            return;
        }
        boolean found = false;
        StringBuilder lines = new StringBuilder();
        while (!found) {
            String eLine = this.readLine(5000L);
            if (eLine == null) {
                throw new Exception("CLI command failed. Sent:" + line + ", received:" + lines.toString());
            }
            lines.append(eLine);
            lines.append(System.getProperty("line.separator"));
            if (eLine.indexOf(line) < 0) continue;
            found = true;
        }
    }

    public void sendLine(String line) throws Exception {
        this.sendLine(line, true);
    }

    public String readLine() {
        return (String)this.outputQueue.poll();
    }

    public String readLine(long timeout) throws Exception {
        String line = null;
        try {
            line = this.outputQueue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ioe) {
            // empty catch block
        }
        if (line == null) {
            throw new Exception("CLI read timeout.");
        }
        return line;
    }

    public String[] readAll(long timeout, long lineTimeout) {
        Vector<String> lines = new Vector<String>();
        try {
            String line = this.outputQueue.poll(timeout, TimeUnit.MILLISECONDS);
            while (line != null) {
                lines.add(line);
                line = this.outputQueue.poll(lineTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException ioe) {
            // empty catch block
        }
        return lines.toArray(new String[0]);
    }

    public String readAllUnformated(long timeout, long lineTimeout) {
        String[] lines = this.readAll(timeout, lineTimeout);
        StringBuilder buf = new StringBuilder();
        for (String line : lines) {
            buf.append(line + " ");
        }
        return buf.toString();
    }

    public CLIOpResult readAllAsOpResult(long timeout, long lineTimeout) throws Exception {
        String output = this.readAllUnformated(timeout, lineTimeout);
        StreamTokenizer st = new StreamTokenizer(new StringReader(output));
        st.resetSyntax();
        st.whitespaceChars(32, 32);
        st.wordChars(35, 43);
        st.wordChars(45, 90);
        st.wordChars(97, 122);
        st.quoteChar(34);
        int token = st.nextToken();
        if (token != 123) {
            throw new CLIException("Parse error. '{' expected, received: '" + token + "'.");
        }
        Map<String, Object> compound = this.parseCompound(st);
        CLIOpResult res = new CLIOpResult();
        res.setIsOutcomeSuccess("success".equals(compound.get("outcome")));
        res.setResult(compound.get("result"));
        return res;
    }

    private Map<String, Object> parseCompound(StreamTokenizer st) throws IOException, ParseException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int token = st.nextToken();
        while (token != 125) {
            String key = st.sval;
            st.nextToken();
            if (!"=>".equals(st.sval)) {
                throw new ParseException("=> expected, got:" + st.sval, st.lineno());
            }
            token = st.nextToken();
            if (token == 123) {
                map.put(key, this.parseCompound(st));
            } else if (token == 91) {
                map.put(key, this.parseList(st));
            } else {
                map.put(key, st.sval);
            }
            if ((token = st.nextToken()) != 44) continue;
            token = st.nextToken();
        }
        return map;
    }

    private List parseList(StreamTokenizer st) throws IOException, ParseException {
        LinkedList<Object> list = new LinkedList<Object>();
        int token = st.nextToken();
        while (token != 93) {
            if (token == 123) {
                list.add(this.parseCompound(st));
            } else if (token == 91) {
                list.add(this.parseList(st));
            } else {
                list.add(st.sval);
            }
            if ((token = st.nextToken()) != 44) continue;
            token = st.nextToken();
        }
        return list;
    }

    public void flush() {
        this.outputQueue.clear();
    }

    public synchronized void quit() throws Exception {
        this.sendLine("quit", false);
        while (this.outputReader != null || this.errorReader != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void init() throws Exception {
        System.out.println("CLI command:" + CLIWrapper.getCliCommand());
        this.cliProcess = Runtime.getRuntime().exec(CLIWrapper.getCliCommand());
        this.writer = new PrintWriter(this.cliProcess.getOutputStream());
        this.outputReader = new BufferedReader(new InputStreamReader(this.cliProcess.getInputStream()));
        this.errorReader = new BufferedReader(new InputStreamReader(this.cliProcess.getErrorStream()));
        Thread readOutputThread = new Thread((Runnable)this, outThreadHame);
        readOutputThread.start();
        Thread readErrorThread = new Thread((Runnable)this, errThreadHame);
        readErrorThread.start();
    }

    private static String getCliCommand() throws Exception {
        if (cliCommand != null) {
            return cliCommand;
        }
        String asDist = System.getProperty("jboss.dist");
        String asInst = System.getProperty("jboss.inst");
        String javaExec = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java";
        if (javaExec.contains(" ")) {
            javaExec = "\"" + javaExec + "\"";
        }
        cliCommand = javaExec + " -Djboss.home.dir=" + asInst + " -Djboss.modules.dir=" + asDist + "/modules" + " -Djline.WindowsTerminal.directConsole=false" + " -jar " + asDist + "/jboss-modules.jar" + " -mp " + asDist + "/modules" + " -logmodule org.jboss.logmanager org.jboss.as.cli" + " --user=" + "testUser" + " --password=" + "test_user_password";
        return cliCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object line;
        String threadName = Thread.currentThread().getName();
        BufferedReader reader = threadName.equals(outThreadHame) ? this.outputReader : this.errorReader;
        try {
            line = reader.readLine();
            while (line != null) {
                if (threadName.equals(outThreadHame)) {
                    this.outputLineReceived((String)line);
                } else {
                    this.errorLineReceived((String)line);
                }
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            CLIWrapper cLIWrapper = this;
            synchronized (cLIWrapper) {
                if (threadName.equals(outThreadHame)) {
                    this.outputReader = null;
                } else {
                    this.errorReader = null;
                }
                this.notifyAll();
            }
        }
        finally {
            line = this;
            synchronized (line) {
                if (threadName.equals(outThreadHame)) {
                    this.outputReader = null;
                } else {
                    this.errorReader = null;
                }
                this.notifyAll();
            }
        }
    }

    private synchronized void outputLineReceived(String line) {
        System.out.println("[CLI-out] " + line);
        this.outputQueue.add(line);
        this.notifyAll();
    }

    private synchronized void errorLineReceived(String line) {
        System.out.println("[CLI-out] " + line);
        this.notifyAll();
    }
}

