/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.configadmin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.ManagementOperations;
import org.jboss.as.test.integration.management.util.MgmtOperationException;
import org.jboss.as.test.integration.management.util.ModelUtil;
import org.jboss.dmr.ModelNode;

public class ConfigAdminManagementOperations {
    public static boolean addConfiguration(ModelControllerClient client, String pid, Map<String, String> entries) throws IOException, MgmtOperationException {
        return ConfigAdminManagementOperations.addOrUpdateConfiguration(client, pid, entries, "add");
    }

    public static List<String> listConfigurations(ModelControllerClient client) throws IOException, MgmtOperationException {
        return ConfigAdminManagementOperations.listChildrenNames(client, "configuration");
    }

    public static Map<String, String> readConfiguration(ModelControllerClient client, String pid) throws IOException, MgmtOperationException {
        ModelNode op = ModelUtil.createOpNode("subsystem=configadmin/configuration=" + pid, "read-resource");
        ModelNode result = ConfigAdminManagementOperations.executeOperation(client, op, true);
        ModelNode entries = result.get("entries");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : entries.keys()) {
            map.put(key, entries.get(key).asString());
        }
        return map;
    }

    public static boolean removeConfiguration(ModelControllerClient client, String pid) throws IOException, MgmtOperationException {
        return ConfigAdminManagementOperations.removeResource(client, "configuration", pid);
    }

    public static boolean updateConfiguration(ModelControllerClient client, String pid, Map<String, String> entries) throws IOException, MgmtOperationException {
        return ConfigAdminManagementOperations.addOrUpdateConfiguration(client, pid, entries, "update");
    }

    private static boolean addOrUpdateConfiguration(ModelControllerClient client, String pid, Map<String, String> entries, String operation) throws IOException, MgmtOperationException {
        ModelNode op = ModelUtil.createOpNode("subsystem=configadmin/configuration=" + pid, operation);
        ModelNode en = new ModelNode();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            en.get(entry.getKey()).set(entry.getValue());
        }
        op.get("entries").set(en);
        ModelNode result = ConfigAdminManagementOperations.executeOperation(client, op, false);
        return "success".equals(result.get("outcome").asString());
    }

    private static ModelNode executeOperation(ModelControllerClient client, ModelNode op, boolean unwrapResult) throws IOException, MgmtOperationException {
        System.out.println(op);
        ModelNode result = unwrapResult ? ManagementOperations.executeOperation(client, op) : ManagementOperations.executeOperationRaw(client, op);
        System.out.println(result);
        return result;
    }

    private static List<String> listChildrenNames(ModelControllerClient client, String type) throws IOException, MgmtOperationException {
        ModelNode op = ModelUtil.createOpNode("subsystem=configadmin", "read-children-names");
        op.get("child-type").set(type);
        ModelNode result = ConfigAdminManagementOperations.executeOperation(client, op, true);
        ArrayList<String> names = new ArrayList<String>();
        for (ModelNode n : result.asList()) {
            names.add(n.asString());
        }
        return names;
    }

    private static boolean removeResource(ModelControllerClient client, String type, String name) throws IOException, MgmtOperationException {
        ModelNode op = ModelUtil.createOpNode("subsystem=configadmin/" + type + "=" + name, "remove");
        ModelNode result = ConfigAdminManagementOperations.executeOperation(client, op, false);
        return "success".equals(result.get("outcome").asString());
    }
}

