/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.threads.AbstractThreadsSubsystemUpdate;
import org.jboss.as.threads.ExecutorRemove;
import org.jboss.as.threads.ScaledCount;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemElement;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public abstract class AbstractExecutorAdd
extends AbstractThreadsSubsystemUpdate<Void> {
    private static final long serialVersionUID = 3661832034337989182L;
    private final String name;
    private final ScaledCount maxThreads;
    private final Map<String, String> properties = new HashMap<String, String>(0);
    private String threadFactory;
    private TimeSpec keepaliveTime;

    protected AbstractExecutorAdd(String name, ScaledCount maxThreads) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (maxThreads == null) {
            throw new IllegalArgumentException("maxThreads is null");
        }
        maxThreads.getScaledCount();
        this.name = name;
        this.maxThreads = maxThreads;
    }

    public String getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(String threadFactory) {
        this.threadFactory = threadFactory;
    }

    public TimeSpec getKeepaliveTime() {
        return this.keepaliveTime;
    }

    public void setKeepaliveTime(TimeSpec keepaliveTime) {
        this.keepaliveTime = keepaliveTime;
    }

    public ScaledCount getMaxThreads() {
        return this.maxThreads;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    protected <T> BatchServiceBuilder<T> addThreadFactoryDependency(ServiceName serviceName, BatchServiceBuilder<T> serviceBuilder, Injector<ThreadFactory> injector, BatchBuilder builder) {
        ServiceName threadFactoryName;
        if (this.threadFactory == null) {
            threadFactoryName = serviceName.append(new String[]{"thread-factory"});
            builder.addService(threadFactoryName, (Service)new ThreadFactoryService());
        } else {
            threadFactoryName = ThreadsServices.threadFactoryName(this.threadFactory);
        }
        return serviceBuilder.addDependency(threadFactoryName, ThreadFactory.class, injector);
    }

    public final ExecutorRemove getCompensatingUpdate(ThreadsSubsystemElement original) {
        return new ExecutorRemove(this.name);
    }
}

