/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.threads.AbstractThreadsSubsystemUpdate;
import org.jboss.as.threads.ScaledCount;
import org.jboss.as.threads.TimeSpec;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class AbstractExecutorElement<T extends AbstractExecutorElement<T>>
extends AbstractModelElement<T> {
    private static final long serialVersionUID = -2409073407325398348L;
    private final String name;
    private final Map<String, String> properties = new HashMap<String, String>();
    private String threadFactory;
    private ScaledCount maxThreads;
    private TimeSpec keepaliveTime;

    protected AbstractExecutorElement(String name) {
        this.name = name;
    }

    protected static void writeTimeSpecElement(XMLExtendedStreamWriter writer, TimeSpec timeSpec, String localName) throws XMLStreamException {
        writer.writeEmptyElement(localName);
        writer.writeAttribute("time", Long.toString(timeSpec.getDuration()));
        writer.writeAttribute("unit", timeSpec.getUnit().toString().toLowerCase(Locale.ENGLISH));
    }

    protected static void writeScaledCountElement(XMLExtendedStreamWriter writer, ScaledCount scaledCount, String localName) throws XMLStreamException {
        BigDecimal perCpu;
        if (scaledCount == null) {
            return;
        }
        writer.writeEmptyElement(localName);
        BigDecimal count = scaledCount.getCount();
        if (count.compareTo(BigDecimal.ZERO) > 0) {
            writer.writeAttribute("count", count.toPlainString());
        }
        if ((perCpu = scaledCount.getPerCpu()).compareTo(BigDecimal.ZERO) > 0) {
            writer.writeAttribute("per-cpu", perCpu.toPlainString());
        }
    }

    public String getThreadFactory() {
        return this.threadFactory;
    }

    void setThreadFactory(String threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ScaledCount getMaxThreads() {
        return this.maxThreads;
    }

    void setMaxThreads(ScaledCount maxThreads) {
        this.maxThreads = maxThreads;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    Map<String, String> getProperties() {
        return this.properties;
    }

    public TimeSpec getKeepaliveTime() {
        return this.keepaliveTime;
    }

    void setKeepaliveTime(TimeSpec keepaliveTime) {
        this.keepaliveTime = keepaliveTime;
    }

    public final String getName() {
        return this.name;
    }

    public final void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        this.writeAttributes(streamWriter);
        this.writeElements(streamWriter);
        streamWriter.writeEndElement();
    }

    protected void writeAttributes(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute("name", this.getName());
    }

    protected void writeElements(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        String threadFactory;
        TimeSpec keepaliveTime;
        ScaledCount maxThreads = this.getMaxThreads();
        if (maxThreads != null) {
            AbstractExecutorElement.writeScaledCountElement(streamWriter, maxThreads, "max-threads");
        }
        if ((keepaliveTime = this.getKeepaliveTime()) != null) {
            AbstractExecutorElement.writeTimeSpecElement(streamWriter, keepaliveTime, "keepalive-time");
        }
        if ((threadFactory = this.getThreadFactory()) != null) {
            streamWriter.writeEmptyElement("thread-factory");
            streamWriter.writeAttribute("name", threadFactory);
        }
        if (!this.properties.isEmpty()) {
            streamWriter.writeStartElement("properties");
            for (String name : this.properties.keySet()) {
                streamWriter.writeEmptyElement("property");
                streamWriter.writeAttribute("name", name);
                streamWriter.writeAttribute("value", this.properties.get(name));
            }
            streamWriter.writeEndElement();
        }
    }

    abstract AbstractThreadsSubsystemUpdate<Void> getAdd();
}

