/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.ChildElement;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.threads.AbstractExecutorAdd;
import org.jboss.as.threads.BoundedQueueThreadPoolElement;
import org.jboss.as.threads.BoundedQueueThreadPoolService;
import org.jboss.as.threads.Element;
import org.jboss.as.threads.ScaledCount;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemElement;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public final class BoundedQueueThreadPoolAdd
extends AbstractExecutorAdd {
    private static final long serialVersionUID = 5597662601486525937L;
    private final ScaledCount queueLength;
    private String handoffExecutor;
    private boolean blocking;
    private boolean allowCoreTimeout;
    private ScaledCount coreThreads;

    public BoundedQueueThreadPoolAdd(String name, ScaledCount maxThreads, ScaledCount queueLength) {
        super(name, maxThreads);
        if (queueLength == null) {
            throw new IllegalArgumentException("queueLength is null");
        }
        this.queueLength = queueLength;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        BatchBuilder builder = updateContext.getBatchBuilder();
        ScaledCount coreThreadsCount = this.getCoreThreads();
        ScaledCount maxThreadsCount = this.getMaxThreads();
        int maxThreads = maxThreadsCount.getScaledCount();
        int coreThreads = coreThreadsCount == null ? maxThreads : coreThreadsCount.getScaledCount();
        int queueLength = this.queueLength.getScaledCount();
        String name = this.getName();
        ServiceName serviceName = ThreadsServices.executorName(name);
        BoundedQueueThreadPoolService service = new BoundedQueueThreadPoolService(coreThreads, maxThreads, queueLength, this.blocking, this.getKeepaliveTime(), this.allowCoreTimeout);
        BatchServiceBuilder serviceBuilder = builder.addService(serviceName, (Service)service);
        this.addThreadFactoryDependency(serviceName, serviceBuilder, service.getThreadFactoryInjector(), builder);
    }

    protected void applyUpdate(ThreadsSubsystemElement element) throws UpdateFailedException {
        BoundedQueueThreadPoolElement poolElement = new BoundedQueueThreadPoolElement(this.getName());
        poolElement.setAllowCoreTimeout(this.allowCoreTimeout);
        poolElement.setBlocking(this.blocking);
        poolElement.setCoreThreads(this.coreThreads);
        poolElement.setHandoffExecutor(this.handoffExecutor);
        poolElement.setQueueLength(this.queueLength);
        poolElement.setKeepaliveTime(this.getKeepaliveTime());
        poolElement.setThreadFactory(this.getThreadFactory());
        poolElement.setMaxThreads(this.getMaxThreads());
        element.addExecutor(this.getName(), new ChildElement(Element.BOUNDED_QUEUE_THREAD_POOL.getLocalName(), (AbstractModelElement)poolElement));
    }

    public String getHandoffExecutor() {
        return this.handoffExecutor;
    }

    public void setHandoffExecutor(String handoffExecutor) {
        this.handoffExecutor = handoffExecutor;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public boolean isAllowCoreTimeout() {
        return this.allowCoreTimeout;
    }

    public void setAllowCoreTimeout(boolean allowCoreTimeout) {
        this.allowCoreTimeout = allowCoreTimeout;
    }

    public ScaledCount getCoreThreads() {
        return this.coreThreads;
    }

    public void setCoreThreads(ScaledCount coreThreads) {
        this.coreThreads = coreThreads;
    }

    public ScaledCount getQueueLength() {
        return this.queueLength;
    }
}

