/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.threads.AbstractThreadsSubsystemUpdate;
import org.jboss.as.threads.ThreadFactoryElement;
import org.jboss.as.threads.ThreadFactoryRemove;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemElement;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistryException;

public final class ThreadFactoryAdd
extends AbstractThreadsSubsystemUpdate<Void> {
    private static final long serialVersionUID = 1935521612404501853L;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final String name;
    private String groupName;
    private String threadNamePattern;
    private Integer priority;

    public ThreadFactoryAdd(String name) {
        super(false);
        this.name = name;
    }

    public ThreadFactoryRemove getCompensatingUpdate(ThreadsSubsystemElement original) {
        return new ThreadFactoryRemove(this.name);
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        ThreadFactoryService service = new ThreadFactoryService();
        service.setNamePattern(this.threadNamePattern);
        service.setPriority(this.priority);
        service.setThreadGroupName(this.groupName);
        UpdateResultHandler.ServiceStartListener listener = new UpdateResultHandler.ServiceStartListener(handler, param);
        BatchBuilder batchBuilder = updateContext.getBatchBuilder();
        BatchServiceBuilder builder = batchBuilder.addService(ThreadsServices.threadFactoryName(this.name), (Service)service);
        builder.addListener((ServiceListener)listener);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        try {
            batchBuilder.install();
        }
        catch (ServiceRegistryException e) {
            handler.handleFailure((Throwable)e, param);
        }
    }

    protected void applyUpdate(ThreadsSubsystemElement element) throws UpdateFailedException {
        ThreadFactoryElement addedElement = element.addThreadFactory(this.name);
        if (addedElement == null) {
            throw new UpdateFailedException("A thread factory named '" + this.name + "' is already registered here");
        }
        if (this.groupName != null) {
            addedElement.setGroupName(this.groupName);
        }
        if (this.threadNamePattern != null) {
            addedElement.setThreadNamePattern(this.threadNamePattern);
        }
        if (this.priority != null) {
            addedElement.setPriority(this.priority);
        }
        if (!this.properties.isEmpty()) {
            addedElement.setProperties(this.properties);
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    public void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

