/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.threads.Attribute;
import org.jboss.as.threads.Element;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ThreadFactoryElement
extends AbstractModelElement<ThreadFactoryElement> {
    private static final long serialVersionUID = 8873007541743218790L;
    private final String name;
    private String groupName;
    private String threadNamePattern;
    private Integer priority;
    private Map<String, String> properties;

    public ThreadFactoryElement(String name) {
        this.name = name;
    }

    protected Class<ThreadFactoryElement> getElementClass() {
        return ThreadFactoryElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute("name", this.name);
        if (this.groupName != null) {
            streamWriter.writeAttribute("thread-group", this.groupName);
        }
        if (this.threadNamePattern != null) {
            streamWriter.writeAttribute("thread-name-pattern", this.threadNamePattern);
        }
        if (this.priority != null) {
            streamWriter.writeAttribute("priority", this.priority.toString());
        }
        if (!this.properties.isEmpty()) {
            streamWriter.writeStartElement(Element.PROPERTIES.getLocalName());
            for (String key : this.properties.keySet()) {
                streamWriter.writeEmptyElement(Element.PROPERTY.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), key);
                streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), this.properties.get(key));
            }
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    public String getName() {
        return this.name;
    }

    void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
    }

    void setPriority(Integer priority) {
        this.priority = priority;
    }

    void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }

    Integer getPriority() {
        return this.priority;
    }

    String getGroupName() {
        return this.groupName;
    }

    String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

