/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Map;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.threads.AbstractThreadsSubsystemUpdate;
import org.jboss.as.threads.ThreadFactoryAdd;
import org.jboss.as.threads.ThreadFactoryElement;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemElement;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public final class ThreadFactoryRemove
extends AbstractThreadsSubsystemUpdate<Void> {
    private static final long serialVersionUID = -6232099966839106128L;
    private final String name;

    public ThreadFactoryRemove(String name) {
        super(false);
        this.name = name;
    }

    public ThreadFactoryAdd getCompensatingUpdate(ThreadsSubsystemElement original) {
        Map<String, String> properties;
        String namePattern;
        String groupName;
        ThreadFactoryAdd add = new ThreadFactoryAdd(this.name);
        ThreadFactoryElement threadFactory = original.getThreadFactory(this.name);
        Integer priority = threadFactory.getPriority();
        if (priority != null) {
            add.setPriority(priority);
        }
        if ((groupName = threadFactory.getGroupName()) != null) {
            add.setGroupName(groupName);
        }
        if ((namePattern = threadFactory.getThreadNamePattern()) != null) {
            add.setThreadNamePattern(namePattern);
        }
        if (!(properties = threadFactory.getProperties()).isEmpty()) {
            add.getProperties().putAll(properties);
        }
        return add;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        ServiceController controller = updateContext.getServiceContainer().getService(ThreadsServices.threadFactoryName(this.name));
        if (controller == null) {
            handler.handleSuccess(null, param);
        } else {
            controller.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(handler, param));
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    protected void applyUpdate(ThreadsSubsystemElement element) throws UpdateFailedException {
        element.removeThreadFactory(this.name);
    }

    public String getName() {
        return this.name;
    }
}

