/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.as.threads.AbstractThreadsSubsystemUpdate;
import org.jboss.as.threads.Attribute;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.Element;
import org.jboss.as.threads.Namespace;
import org.jboss.as.threads.QueuelessThreadPoolAdd;
import org.jboss.as.threads.ScaledCount;
import org.jboss.as.threads.ScheduledThreadPoolAdd;
import org.jboss.as.threads.ThreadFactoryAdd;
import org.jboss.as.threads.ThreadsSubsystemAdd;
import org.jboss.as.threads.ThreadsSubsystemElement;
import org.jboss.as.threads.TimeSpec;
import org.jboss.as.threads.UnboundedQueueThreadPoolAdd;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class ThreadsParser
implements XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<ThreadsSubsystemElement>>> {
    private static final ThreadsParser INSTANCE = new ThreadsParser();
    static final Map<String, String> UNIT_NICK_NAMES = ThreadsParser.stringMap(ThreadsParser.entry("S", "SECONDS"), ThreadsParser.entry("SEC", "SECONDS"), ThreadsParser.entry("SECOND", "SECONDS"), ThreadsParser.entry("SECONDS", "SECONDS"), ThreadsParser.entry("M", "MINUTES"), ThreadsParser.entry("MIN", "MINUTES"), ThreadsParser.entry("MINUTE", "MINUTES"), ThreadsParser.entry("MINUTES", "MINUTES"), ThreadsParser.entry("MS", "MILLISECONDS"), ThreadsParser.entry("MILLIS", "MILLISECONDS"), ThreadsParser.entry("MILLISECOND", "MILLISECONDS"), ThreadsParser.entry("MILLISECONDS", "MILLISECONDS"), ThreadsParser.entry("NS", "NANOSECONDS"), ThreadsParser.entry("NANOS", "NANOSECONDS"), ThreadsParser.entry("NANOSECOND", "NANOSECONDS"), ThreadsParser.entry("NANOSECONDS", "NANOSECONDS"), ThreadsParser.entry("H", "HOURS"), ThreadsParser.entry("HOUR", "HOURS"), ThreadsParser.entry("HOURS", "HOURS"), ThreadsParser.entry("D", "DAYS"), ThreadsParser.entry("DAY", "DAYS"), ThreadsParser.entry("DAYS", "DAYS"), ThreadsParser.entry("MON", "MONTHS"), ThreadsParser.entry("MONTH", "MONTHS"), ThreadsParser.entry("MONTHS", "MONTHS"), ThreadsParser.entry("W", "WEEKS"), ThreadsParser.entry("WEEK", "WEEKS"), ThreadsParser.entry("WEEKS", "WEEKS"));

    private ThreadsParser() {
    }

    public static ThreadsParser getInstance() {
        return INSTANCE;
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<ThreadsSubsystemElement>> result) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> threadFactoryNames = new HashSet<String>();
        HashSet<String> executorNames = new HashSet<String>();
        HashSet<String> scheduledExecutorNames = new HashSet<String>();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case THREADS_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case THREAD_FACTORY: {
                            this.parseThreadFactoryElement(reader, updates, threadFactoryNames);
                            continue block10;
                        }
                        case SCHEDULED_THREAD_POOL: {
                            this.parseScheduledExecutorElement(reader, updates, scheduledExecutorNames);
                            continue block10;
                        }
                        case BOUNDED_QUEUE_THREAD_POOL: {
                            this.parseBoundedQueueExecutorElement(reader, updates, executorNames);
                            continue block10;
                        }
                        case QUEUELESS_THREAD_POOL: {
                            this.parseQueuelessExecutorElement(reader, updates, executorNames);
                            continue block10;
                        }
                        case UNBOUNDED_QUEUE_THREAD_POOL: {
                            this.parseUnboundedQueueExecutorElement(reader, updates, executorNames);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)new ThreadsSubsystemAdd(), updates));
    }

    private void parseUnboundedQueueExecutorElement(XMLExtendedStreamReader reader, List<? super AbstractThreadsSubsystemUpdate<?>> updates, Set<String> names) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int cnt = reader.getAttributeCount();
        block12: for (int i = 0; i < cnt; ++i) {
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        ScaledCount maxThreads = null;
        TimeSpec keepaliveTime = null;
        String threadFactory = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.MAX_THREADS);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case MAX_THREADS: {
                    maxThreads = ThreadsParser.readScaledCountElement(reader);
                    continue block13;
                }
                case KEEPALIVE_TIME: {
                    keepaliveTime = ThreadsParser.readTimeSpecElement(reader);
                    continue block13;
                }
                case THREAD_FACTORY: {
                    threadFactory = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    continue block13;
                }
                case PROPERTIES: {
                    while (reader.nextTag() != 2) {
                        while (reader.nextTag() != 2) {
                        }
                    }
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        UnboundedQueueThreadPoolAdd add = new UnboundedQueueThreadPoolAdd(name, maxThreads);
        add.setKeepaliveTime(keepaliveTime);
        add.setThreadFactory(threadFactory);
        updates.add(add);
    }

    private void parseQueuelessExecutorElement(XMLExtendedStreamReader reader, List<? super AbstractThreadsSubsystemUpdate<?>> updates, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean blocking = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int cnt = reader.getAttributeCount();
        block14: for (int i = 0; i < cnt; ++i) {
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block14;
                }
                case BLOCKING: {
                    blocking = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        ScaledCount maxThreads = null;
        TimeSpec keepaliveTime = null;
        String threadFactory = null;
        String handoffExecutor = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.MAX_THREADS);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block15: while (reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case MAX_THREADS: {
                    maxThreads = ThreadsParser.readScaledCountElement(reader);
                    continue block15;
                }
                case KEEPALIVE_TIME: {
                    keepaliveTime = ThreadsParser.readTimeSpecElement(reader);
                    continue block15;
                }
                case THREAD_FACTORY: {
                    threadFactory = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    continue block15;
                }
                case HANDOFF_EXECUTOR: {
                    handoffExecutor = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    continue block15;
                }
                case PROPERTIES: {
                    while (reader.nextTag() != 2) {
                        while (reader.nextTag() != 2) {
                        }
                    }
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        QueuelessThreadPoolAdd add = new QueuelessThreadPoolAdd(name, maxThreads);
        add.setKeepaliveTime(keepaliveTime);
        add.setThreadFactory(threadFactory);
        add.setBlocking(blocking);
        add.setHandoffExecutor(handoffExecutor);
        updates.add(add);
    }

    private void parseThreadFactoryElement(XMLExtendedStreamReader reader, List<? super ThreadFactoryAdd> updates, Set<String> names) throws XMLStreamException {
        String name = null;
        String groupName = null;
        String threadNamePattern = null;
        Integer priority = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int cnt = reader.getAttributeCount();
        block6: for (int i = 0; i < cnt; ++i) {
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                case GROUP_NAME: {
                    groupName = reader.getAttributeValue(i);
                    continue block6;
                }
                case THREAD_NAME_PATTERN: {
                    threadNamePattern = reader.getAttributeValue(i);
                    continue block6;
                }
                case PRIORITY: {
                    int val = reader.getIntAttributeValue(i);
                    if (val < 1 || val > 10) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    priority = val;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        ThreadFactoryAdd add = new ThreadFactoryAdd(name);
        if (groupName != null) {
            add.setGroupName(groupName);
        }
        if (threadNamePattern != null) {
            add.setThreadNamePattern(threadNamePattern);
        }
        if (priority != null) {
            add.setPriority(priority);
        }
        Map<String, String> map = add.getProperties();
        if (reader.nextTag() != 2) {
            reader.require(1, Namespace.CURRENT.getUriString(), Element.PROPERTIES.getLocalName());
            while (reader.nextTag() != 2) {
                reader.require(1, Namespace.CURRENT.getUriString(), Element.PROPERTY.getLocalName());
                ParseUtils.readProperty((XMLExtendedStreamReader)reader).addTo(map);
            }
        }
        updates.add(add);
    }

    private void parseScheduledExecutorElement(XMLExtendedStreamReader reader, List<? super ScheduledThreadPoolAdd> updates, Set<String> names) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String name = reader.getAttributeValue(0);
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)name);
        }
        ScaledCount maxSize = null;
        TimeSpec keepaliveTime = null;
        String threadFactoryRef = null;
        HashMap map = new HashMap();
        EnumSet<Element> required = EnumSet.of(Element.MAX_THREADS);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        while (reader.nextTag() != 2) {
            if (!reader.getNamespaceURI().equals(Namespace.CURRENT.getUriString())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case MAX_THREADS: {
                    maxSize = ThreadsParser.readScaledCountElement(reader);
                    break;
                }
                case KEEPALIVE_TIME: {
                    keepaliveTime = ThreadsParser.readTimeSpecElement(reader);
                }
            }
        }
        ScheduledThreadPoolAdd add = new ScheduledThreadPoolAdd(name, maxSize);
        if (keepaliveTime != null) {
            add.setKeepaliveTime(keepaliveTime);
        }
        if (threadFactoryRef != null) {
            add.setThreadFactory(threadFactoryRef);
        }
        add.getProperties().putAll(map);
        updates.add(add);
    }

    private void parseBoundedQueueExecutorElement(XMLExtendedStreamReader reader, List<? super AbstractThreadsSubsystemUpdate<?>> updates, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean allowCoreTimeout = false;
        boolean blocking = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int cnt = reader.getAttributeCount();
        block17: for (int i = 0; i < cnt; ++i) {
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block17;
                }
                case ALLOW_CORE_TIMEOUT: {
                    allowCoreTimeout = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block17;
                }
                case BLOCKING: {
                    blocking = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        ScaledCount coreThreads = null;
        ScaledCount queueLength = null;
        ScaledCount maxThreads = null;
        TimeSpec keepaliveTime = null;
        String threadFactory = null;
        String handoffExecutor = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.MAX_THREADS);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block18: while (reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case CORE_THREADS: {
                    coreThreads = ThreadsParser.readScaledCountElement(reader);
                    continue block18;
                }
                case QUEUE_LENGTH: {
                    queueLength = ThreadsParser.readScaledCountElement(reader);
                    continue block18;
                }
                case MAX_THREADS: {
                    maxThreads = ThreadsParser.readScaledCountElement(reader);
                    continue block18;
                }
                case KEEPALIVE_TIME: {
                    keepaliveTime = ThreadsParser.readTimeSpecElement(reader);
                    continue block18;
                }
                case THREAD_FACTORY: {
                    threadFactory = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    continue block18;
                }
                case HANDOFF_EXECUTOR: {
                    handoffExecutor = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    continue block18;
                }
                case PROPERTIES: {
                    while (reader.nextTag() != 2) {
                        while (reader.nextTag() != 2) {
                        }
                    }
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        BoundedQueueThreadPoolAdd add = new BoundedQueueThreadPoolAdd(name, maxThreads, queueLength);
        add.setBlocking(blocking);
        add.setAllowCoreTimeout(allowCoreTimeout);
        add.setCoreThreads(coreThreads);
        add.setHandoffExecutor(handoffExecutor);
        add.setKeepaliveTime(keepaliveTime);
        add.setThreadFactory(threadFactory);
        updates.add(add);
    }

    protected static TimeSpec readTimeSpecElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        TimeUnit unit = null;
        long qty = -1L;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            switch (Attribute.forName(reader.getAttributeLocalName(i))) {
                case TIME: {
                    qty = reader.getLongAttributeValue(i);
                    continue block4;
                }
                case UNIT: {
                    String val = reader.getAttributeValue(i);
                    unit = Enum.valueOf(TimeUnit.class, val.toUpperCase());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (qty == -1L) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TIME));
        }
        if (unit == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.UNIT));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return new TimeSpec(unit, qty);
    }

    protected static ScaledCount readScaledCountElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        BigDecimal perCpu = null;
        BigDecimal count = null;
        int acnt = reader.getAttributeCount();
        block4: for (int i = 0; i < acnt; ++i) {
            switch (Attribute.forName(reader.getAttributeLocalName(i))) {
                case PER_CPU: {
                    perCpu = new BigDecimal(reader.getAttributeValue(i), MathContext.DECIMAL64);
                    continue block4;
                }
                case COUNT: {
                    count = new BigDecimal(reader.getAttributeValue(i), MathContext.DECIMAL64);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (perCpu == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PER_CPU));
        }
        if (count == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.COUNT));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return new ScaledCount(count, perCpu);
    }

    private static StringEntry entry(String key, String value) {
        return new StringEntry(key, value);
    }

    private static Map<String, String> stringMap(StringEntry ... entries) {
        HashMap hashMap = new HashMap(entries.length);
        for (StringEntry e : entries) {
            hashMap.put(e.getKey(), e.getValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static final class StringEntry
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        private StringEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }
}

