/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.threads.BoundedQueueThreadPoolService;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.as.threads.ThreadsSubsystemThreadPoolOperationUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class BoundedQueueThreadPoolAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final BoundedQueueThreadPoolAdd INSTANCE = new BoundedQueueThreadPoolAdd();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.KEEPALIVE_TIME, PoolAttributeDefinitions.MAX_THREADS, PoolAttributeDefinitions.PROPERTIES, PoolAttributeDefinitions.THREAD_FACTORY, PoolAttributeDefinitions.CORE_THREADS, PoolAttributeDefinitions.QUEUE_LENGTH, PoolAttributeDefinitions.HANDOFF_EXECUTOR, PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT, PoolAttributeDefinitions.BLOCKING};
    static final AttributeDefinition[] RW_ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.KEEPALIVE_TIME, PoolAttributeDefinitions.MAX_THREADS, PoolAttributeDefinitions.CORE_THREADS, PoolAttributeDefinitions.QUEUE_LENGTH, PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT, PoolAttributeDefinitions.BLOCKING};

    public ModelNode getModelDescription(Locale locale) {
        return ThreadsSubsystemProviders.ADD_BOUNDED_QUEUE_THREAD_POOL_DESC.getModelDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        model.get("name").set(name);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode resolved = new ModelNode();
        resolved.get("operation").set(operation.get("operation"));
        resolved.get("address").set(operation.get("address"));
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resolved.get(attribute.getName()).set(attribute.resolveModelAttribute(context, model));
        }
        ThreadsSubsystemThreadPoolOperationUtils.BoundedOperationParameters params = ThreadsSubsystemThreadPoolOperationUtils.parseBoundedThreadPoolOperationParameters(resolved);
        ServiceTarget target = context.getServiceTarget();
        int coreThreads = params.getCoreThreads() == null ? params.getMaxThreads().getScaledCount() : params.getCoreThreads().getScaledCount();
        ServiceName serviceName = ThreadsServices.executorName(params.getName());
        BoundedQueueThreadPoolService service = new BoundedQueueThreadPoolService(coreThreads, params.getMaxThreads().getScaledCount(), params.getQueueLength().getScaledCount(), params.isBlocking(), params.getKeepAliveTime(), params.isAllowCoreTimeout());
        ServiceBuilder serviceBuilder = target.addService(serviceName, (Service)service);
        ThreadsSubsystemThreadPoolOperationUtils.addThreadFactoryDependency(params.getThreadFactory(), serviceName, serviceBuilder, service.getThreadFactoryInjector(), target, params.getName() + "-threads");
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController sc = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
    }
}

