/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public abstract class ThreadsWriteAttributeOperationHandler
extends AbstractWriteAttributeHandler<Boolean> {
    private static final EnumSet<AttributeAccess.Flag> RESTART_NONE = EnumSet.of(AttributeAccess.Flag.RESTART_NONE);
    private static final EnumSet<AttributeAccess.Flag> RESTART_ALL = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
    protected final AttributeDefinition[] attributes;
    protected final Map<String, AttributeDefinition> runtimeAttributes = new HashMap<String, AttributeDefinition>();

    public ThreadsWriteAttributeOperationHandler(AttributeDefinition[] attrs, AttributeDefinition[] rwAttrs) {
        super(attrs);
        this.attributes = attrs;
        for (AttributeDefinition attr : rwAttrs) {
            this.runtimeAttributes.put(attr.getName(), attr);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
        AttributeDefinition attr = this.runtimeAttributes.get(attributeName);
        if (attr == null) {
            return true;
        }
        ServiceController<?> service = this.getService(context, operation);
        if (service == null) {
            return false;
        }
        if (service.getState() != ServiceController.State.UP) {
            return true;
        }
        this.applyOperation(context, operation, attributeName, service);
        handbackHolder.setHandback((Object)Boolean.TRUE);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
        ServiceController<?> service;
        if (handback != null && handback.booleanValue() && this.runtimeAttributes.containsKey(attributeName) && (service = this.getService(context, operation)) != null && service.getState() == ServiceController.State.UP) {
            ModelNode revertOp = operation.clone();
            revertOp.get(attributeName).set(valueToRestore);
            this.applyOperation(context, revertOp, attributeName, service);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attribute : this.attributes) {
            String attrName = attribute.getName();
            EnumSet<AttributeAccess.Flag> flags = this.runtimeAttributes.containsKey(attrName) ? RESTART_NONE : RESTART_ALL;
            registry.registerReadWriteAttribute(attrName, null, (OperationStepHandler)this, flags);
        }
    }

    protected abstract ServiceController<?> getService(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected abstract void applyOperation(OperationContext var1, ModelNode var2, String var3, ServiceController<?> var4);
}

