/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.net.SocketBinding;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.as.services.path.RelativePathService;
import org.jboss.as.txn.Namespace;
import org.jboss.as.txn.TransactionManagerService;
import org.jboss.as.txn.TransactionsSubsystemElement;
import org.jboss.as.txn.TxnServices;
import org.jboss.as.txn.XATerminatorService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.tm.JBossXATerminator;
import org.omg.CORBA.ORB;

public final class TransactionSubsystemAdd
extends AbstractSubsystemAdd<TransactionsSubsystemElement> {
    private static final long serialVersionUID = 6904905763469774913L;
    private static final String INTERNAL_OBJECTSTORE_PATH = "jboss.transactions.object.store.path";
    private String recoveryBindingName;
    private String recoveryStatusBindingName;
    private String nodeIdentifier = "1";
    private String bindingName;
    private boolean coordinatorEnableStatistics;
    private String objectStorePathRef = "jboss.server.data.dir";
    private String objectStorePath = "tx-object-store";
    private int maxPorts = 10;
    private int coordinatorDefaultTimeout = 300;

    protected TransactionSubsystemAdd() {
        super(Namespace.CURRENT.getUriString());
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        BatchBuilder builder = updateContext.getBatchBuilder();
        XATerminatorService xaTerminatorService = new XATerminatorService();
        builder.addService(TxnServices.JBOSS_TXN_XA_TERMINATOR, (Service)xaTerminatorService).setInitialMode(ServiceController.Mode.ACTIVE);
        TransactionManagerService transactionManagerService = new TransactionManagerService(this.nodeIdentifier, this.maxPorts, this.coordinatorEnableStatistics, this.coordinatorDefaultTimeout);
        BatchServiceBuilder transactionManagerServiceBuilder = builder.addService(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, (Service)transactionManagerService);
        transactionManagerServiceBuilder.addOptionalDependency(ServiceName.JBOSS.append(new String[]{"iiop", "orb"}), ORB.class, transactionManagerService.getOrbInjector());
        transactionManagerServiceBuilder.addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, transactionManagerService.getXaTerminatorInjector());
        transactionManagerServiceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{this.recoveryBindingName}), SocketBinding.class, transactionManagerService.getRecoveryBindingInjector());
        transactionManagerServiceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{this.recoveryStatusBindingName}), SocketBinding.class, transactionManagerService.getStatusBindingInjector());
        transactionManagerServiceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{this.bindingName}), SocketBinding.class, transactionManagerService.getSocketProcessBindingInjector());
        transactionManagerServiceBuilder.addDependency(AbstractPathService.pathNameOf((String)INTERNAL_OBJECTSTORE_PATH), String.class, transactionManagerService.getPathInjector());
        transactionManagerServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        RelativePathService.addService((String)INTERNAL_OBJECTSTORE_PATH, (String)this.objectStorePath, (String)this.objectStorePathRef, (BatchBuilder)builder);
    }

    protected TransactionsSubsystemElement createSubsystemElement() {
        TransactionsSubsystemElement element = new TransactionsSubsystemElement();
        element.getCoreEnvironmentElement().setBindingRef(this.bindingName);
        element.getCoreEnvironmentElement().setMaxPorts(this.maxPorts);
        element.getCoreEnvironmentElement().setNodeIdentifier(this.nodeIdentifier);
        element.getRecoveryEnvironmentElement().setBindingRef(this.recoveryBindingName);
        element.getRecoveryEnvironmentElement().setStatusBindingRef(this.recoveryStatusBindingName);
        element.getObjectStoreEnvironmentElement().setRelativeTo(this.objectStorePathRef);
        element.getObjectStoreEnvironmentElement().setPath(this.objectStorePath);
        element.setCoordinatorDefaultTimeout(this.coordinatorDefaultTimeout);
        element.setCoordinatorEnableStatistics(this.coordinatorEnableStatistics);
        return element;
    }

    public String getRecoveryBindingName() {
        return this.recoveryBindingName;
    }

    public void setRecoveryBindingName(String recoveryBindingName) {
        this.recoveryBindingName = recoveryBindingName;
    }

    public String getRecoveryStatusBindingName() {
        return this.recoveryStatusBindingName;
    }

    public void setRecoveryStatusBindingName(String recoveryStatusBindingName) {
        this.recoveryStatusBindingName = recoveryStatusBindingName;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(String nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public boolean isCoordinatorEnableStatistics() {
        return this.coordinatorEnableStatistics;
    }

    public void setCoordinatorEnableStatistics(boolean coordinatorEnableStatistics) {
        this.coordinatorEnableStatistics = coordinatorEnableStatistics;
    }

    public void setCoordinatorDefaultTimeout(int timeout) {
        this.coordinatorDefaultTimeout = timeout;
    }

    public String getObjectStoreDirectory() {
        return this.objectStorePath;
    }

    public String getObjectStorePathRef() {
        return this.objectStorePathRef;
    }

    public void setObjectStorePathRef(String objectStorePathRef) {
        this.objectStorePathRef = objectStorePathRef;
    }

    public void setObjectStoreDirectory(String objectStoreDirectory) {
        this.objectStorePath = objectStoreDirectory;
    }

    public int getMaxPorts() {
        return this.maxPorts;
    }

    public void setMaxPorts(int maxPorts) {
        this.maxPorts = maxPorts;
    }
}

