/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.as.txn.Attribute;
import org.jboss.as.txn.CoreEnvironmentElement;
import org.jboss.as.txn.Element;
import org.jboss.as.txn.Namespace;
import org.jboss.as.txn.TransactionSubsystemAdd;
import org.jboss.as.txn.TransactionsSubsystemElement;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class TransactionSubsystemElementParser
implements XMLStreamConstants,
XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<TransactionsSubsystemElement>>> {
    private static final TransactionSubsystemElementParser INSTANCE = new TransactionSubsystemElementParser();

    private TransactionSubsystemElementParser() {
    }

    public static TransactionSubsystemElementParser getInstance() {
        return INSTANCE;
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<TransactionsSubsystemElement>> result) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        TransactionSubsystemAdd add = new TransactionSubsystemAdd();
        EnumSet<Element> required = EnumSet.of(Element.RECOVERY_ENVIRONMENT, Element.CORE_ENVIRONMENT);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case TRANSACTIONS_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    required.remove((Object)element);
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case RECOVERY_ENVIRONMENT: {
                            this.parseRecoveryEnvironmentElement(reader, add);
                            continue block9;
                        }
                        case CORE_ENVIRONMENT: {
                            this.parseCoreEnvironmentElement(reader, add);
                            continue block9;
                        }
                        case COORDINATOR_ENVIRONMENT: {
                            this.parseCoordinatorEnvironmentElement(reader, add);
                            continue block9;
                        }
                        case OBJECT_STORE: {
                            this.parseObjectStoreEnvironmentElement(reader, add);
                            continue block9;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)add, updates));
    }

    void parseRecoveryEnvironmentElement(XMLExtendedStreamReader reader, TransactionSubsystemAdd add) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BINDING: {
                    add.setRecoveryBindingName(value);
                    continue block4;
                }
                case STATUS_BINDING: {
                    add.setRecoveryStatusBindingName(value);
                    continue block4;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (add.getBindingName() == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BINDING));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    CoreEnvironmentElement parseCoreEnvironmentElement(XMLExtendedStreamReader reader, TransactionSubsystemAdd add) throws XMLStreamException {
        CoreEnvironmentElement element = new CoreEnvironmentElement();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BINDING);
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case BINDING: {
                    add.setBindingName(value);
                    continue block5;
                }
                case NODE_IDENTIFIER: {
                    add.setNodeIdentifier(value);
                    continue block5;
                }
                case SOCKET_PROCESS_ID_MAX_PORTS: {
                    add.setMaxPorts(Integer.parseInt(value));
                    continue block5;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return element;
    }

    void parseCoordinatorEnvironmentElement(XMLExtendedStreamReader reader, TransactionSubsystemAdd add) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLE_STATISTICS: {
                    add.setCoordinatorEnableStatistics(Boolean.parseBoolean(value));
                    continue block4;
                }
                case DEFAULT_TIMEOUT: {
                    add.setCoordinatorDefaultTimeout(Integer.parseInt(value));
                    continue block4;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void parseObjectStoreEnvironmentElement(XMLExtendedStreamReader reader, TransactionSubsystemAdd add) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    add.setObjectStorePathRef(value);
                    continue block4;
                }
                case PATH: {
                    add.setObjectStoreDirectory(value);
                    continue block4;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

