/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.ee;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.as.metadata.parser.ee.Attribute;
import org.jboss.as.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.as.metadata.parser.ee.Element;
import org.jboss.as.metadata.parser.ee.PropertyMetaDataParser;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.IsolationLevelType;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;

public class DataSourceMetaDataParser
extends MetaDataElementParser {
    public static DataSourceMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        DataSourceMetaData dataSource = new DataSourceMetaData();
        int count = reader.getAttributeCount();
        block22: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    dataSource.setId(value);
                    continue block22;
                }
                default: {
                    throw DataSourceMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block23: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions)) {
                if (dataSource.getDescriptions() != null) continue;
                dataSource.setDescriptions((Descriptions)descriptions);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    dataSource.setName(reader.getElementText());
                    continue block23;
                }
                case CLASS_NAME: {
                    dataSource.setClassName(reader.getElementText());
                    continue block23;
                }
                case SERVER_NAME: {
                    dataSource.setServerName(reader.getElementText());
                    continue block23;
                }
                case PORT_NUMBER: {
                    dataSource.setPortNumber(Integer.valueOf(reader.getElementText()).intValue());
                    continue block23;
                }
                case DATABASE_NAME: {
                    dataSource.setDatabaseName(reader.getElementText());
                    continue block23;
                }
                case URL: {
                    dataSource.setUrl(reader.getElementText());
                    continue block23;
                }
                case USER: {
                    dataSource.setUser(reader.getElementText());
                    continue block23;
                }
                case PASSWORD: {
                    dataSource.setPassword(reader.getElementText());
                    continue block23;
                }
                case PROPERTY: {
                    PropertiesMetaData properties = dataSource.getProperties();
                    if (properties == null) {
                        properties = new PropertiesMetaData();
                        dataSource.setProperties(properties);
                    }
                    properties.add((MappableMetaData)PropertyMetaDataParser.parse(reader));
                    continue block23;
                }
                case LOGIN_TIMEOUT: {
                    dataSource.setLoginTimeout(Integer.valueOf(reader.getElementText()).intValue());
                    continue block23;
                }
                case TRANSACTIONAL: {
                    dataSource.setTransactional(Boolean.valueOf(reader.getElementText()).booleanValue());
                    continue block23;
                }
                case ISOLATION_LEVEL: {
                    dataSource.setIsolationLevel(IsolationLevelType.valueOf((String)reader.getElementText()));
                    continue block23;
                }
                case INITAL_POOL_SIZE: {
                    dataSource.setInitialPoolSize(Integer.valueOf(reader.getElementText()).intValue());
                    continue block23;
                }
                case MAX_POOL_SIZE: {
                    dataSource.setMaxPoolSize(Integer.valueOf(reader.getElementText()).intValue());
                    continue block23;
                }
                case MIN_POOL_SIZE: {
                    dataSource.setMinPoolSize(Integer.valueOf(reader.getElementText()).intValue());
                    continue block23;
                }
                case MAX_IDLE_TIME: {
                    dataSource.setMaxIdleTime(Integer.valueOf(reader.getElementText()).intValue());
                    continue block23;
                }
                case MAX_STATEMENTS: {
                    dataSource.setMaxStatements(Integer.valueOf(reader.getElementText()).intValue());
                    continue block23;
                }
            }
            throw DataSourceMetaDataParser.unexpectedElement(reader);
        }
        return dataSource;
    }
}

