/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.servlet;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.servlet.Attribute;
import org.jboss.as.metadata.parser.servlet.Element;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;

public class MultipartConfigMetaDataParser
extends MetaDataElementParser {
    public static MultipartConfigMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        MultipartConfigMetaData multipartConfig = new MultipartConfigMetaData();
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    multipartConfig.setId(value);
                    continue block15;
                }
                default: {
                    throw MultipartConfigMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOCATION: {
                    multipartConfig.setLocation(reader.getElementText());
                    continue block16;
                }
                case MAX_FILE_SIZE: {
                    try {
                        multipartConfig.setMaxFileSize(Long.valueOf(reader.getElementText()).longValue());
                        continue block16;
                    }
                    catch (NumberFormatException e) {
                        throw MultipartConfigMetaDataParser.unexpectedValue(reader, e);
                    }
                }
                case MAX_REQUEST_SIZE: {
                    try {
                        multipartConfig.setMaxRequestSize(Long.valueOf(reader.getElementText()).longValue());
                        continue block16;
                    }
                    catch (NumberFormatException e) {
                        throw MultipartConfigMetaDataParser.unexpectedValue(reader, e);
                    }
                }
                case FILE_SIZE_THRESHOLD: {
                    try {
                        multipartConfig.setFileSizeThreshold(Integer.valueOf(reader.getElementText()).intValue());
                        continue block16;
                    }
                    catch (NumberFormatException e) {
                        throw MultipartConfigMetaDataParser.unexpectedValue(reader, e);
                    }
                }
            }
            throw MultipartConfigMetaDataParser.unexpectedElement(reader);
        }
        return multipartConfig;
    }
}

