/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.servlet;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.as.metadata.parser.ee.ParamValueMetaDataParser;
import org.jboss.as.metadata.parser.ee.RunAsMetaDataParser;
import org.jboss.as.metadata.parser.ee.SecurityRoleRefMetaDataParser;
import org.jboss.as.metadata.parser.servlet.Attribute;
import org.jboss.as.metadata.parser.servlet.Element;
import org.jboss.as.metadata.parser.servlet.MultipartConfigMetaDataParser;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;

public class ServletMetaDataParser
extends MetaDataElementParser {
    public static ServletMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        ServletMetaData servlet = new ServletMetaData();
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    servlet.setId(value);
                    continue block15;
                }
                default: {
                    throw ServletMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse(reader, descriptionGroup)) {
                if (servlet.getDescriptionGroup() != null) continue;
                servlet.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVLET_NAME: {
                    servlet.setServletName(reader.getElementText());
                    continue block16;
                }
                case SERVLET_CLASS: {
                    servlet.setServletClass(reader.getElementText());
                    continue block16;
                }
                case JSP_FILE: {
                    servlet.setJspFile(reader.getElementText());
                    continue block16;
                }
                case INIT_PARAM: {
                    ArrayList<ParamValueMetaData> initParams = servlet.getInitParam();
                    if (initParams == null) {
                        initParams = new ArrayList<ParamValueMetaData>();
                        servlet.setInitParam(initParams);
                    }
                    initParams.add(ParamValueMetaDataParser.parse(reader));
                    continue block16;
                }
                case LOAD_ON_STARTUP: {
                    servlet.setLoadOnStartup(reader.getElementText());
                    continue block16;
                }
                case ENABLED: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(reader.getElementText()))) {
                        servlet.setEnabled(true);
                        continue block16;
                    }
                    servlet.setEnabled(false);
                    continue block16;
                }
                case ASYNC_SUPPORTED: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(reader.getElementText()))) {
                        servlet.setAsyncSupported(true);
                        continue block16;
                    }
                    servlet.setAsyncSupported(false);
                    continue block16;
                }
                case RUN_AS: {
                    servlet.setRunAs(RunAsMetaDataParser.parse(reader));
                    continue block16;
                }
                case SECURITY_ROLE_REF: {
                    SecurityRoleRefsMetaData securityRoleRefs = servlet.getSecurityRoleRefs();
                    if (securityRoleRefs == null) {
                        securityRoleRefs = new SecurityRoleRefsMetaData();
                        servlet.setSecurityRoleRefs(securityRoleRefs);
                    }
                    securityRoleRefs.add((MappableMetaData)SecurityRoleRefMetaDataParser.parse(reader));
                    continue block16;
                }
                case MULTIPART_CONFIG: {
                    servlet.setMultipartConfig(MultipartConfigMetaDataParser.parse(reader));
                    continue block16;
                }
            }
            throw ServletMetaDataParser.unexpectedElement(reader);
        }
        return servlet;
    }
}

