/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    ACCESS_LOG("access-log"),
    ALIAS("alias"),
    CONNECTOR("connector"),
    CONTAINER_CONFIG("config"),
    DIRECTORY("directory"),
    JSP_CONFIGURATION("jsp-configuration"),
    MIME_MAPPING("mime-mapping"),
    REWRITE("rewrite"),
    STATIC_RESOURCES("static-resources"),
    SUBSYSTEM("subsystem"),
    VIRTUAL_SERVER("virtual-server"),
    WELCOME_FILE("welcome-file");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

