/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.web.AbstractWebSubsystemUpdate;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebConnectorElement;
import org.jboss.as.web.WebSubsystemElement;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class WebConnectorRemove
extends AbstractWebSubsystemUpdate<Void> {
    private static final long serialVersionUID = -5287654247889240561L;
    private final String name;

    public WebConnectorRemove(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null connector name");
        }
        this.name = name;
    }

    protected void applyUpdate(WebSubsystemElement element) throws UpdateFailedException {
        if (!element.removeConnector(this.name)) {
            throw new UpdateFailedException("no such connector " + this.name);
        }
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController service = context.getServiceContainer().getService(WebSubsystemElement.JBOSS_WEB_CONNECTOR.append(new String[]{this.name}));
        if (service == null) {
            resultHandler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
        }
    }

    public AbstractSubsystemUpdate<WebSubsystemElement, ?> getCompensatingUpdate(WebSubsystemElement original) {
        WebConnectorElement connector = original.getConnector(this.name);
        if (connector == null) {
            return null;
        }
        WebConnectorAdd action = new WebConnectorAdd(this.name);
        action.setBindingRef(connector.getBindingRef());
        action.setProtocol(connector.getProtocol());
        action.setScheme(connector.getScheme());
        action.setExecutorRef(connector.getExecutorRef());
        action.setEnabled(connector.isEnabled());
        action.setRedirectPort(connector.getRedirectPort());
        action.setProxyName(connector.getProxyName());
        action.setProxyPort(connector.getProxyPort());
        action.setEnableLookups(connector.isEnableLookups());
        action.setMaxPostSize(connector.getMaxPostSize());
        action.setMaxSavePostSize(connector.getMaxSavePostSize());
        action.setSecure(connector.isSecure());
        return action;
    }
}

