/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import javax.management.MBeanServer;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.SharedTldsMetaDataBuilder;
import org.jboss.as.web.SharedWebMetaDataBuilder;
import org.jboss.as.web.WebContainerConfigElement;
import org.jboss.as.web.WebDeploymentActivator;
import org.jboss.as.web.WebServerService;
import org.jboss.as.web.WebSubsystemElement;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class WebSubsystemAdd
extends AbstractSubsystemAdd<WebSubsystemElement> {
    private static final long serialVersionUID = 1079329665126341623L;
    private static final String BASE_DIR = "jboss.home.dir";
    private String defaultHost;
    private WebContainerConfigElement config;

    public WebSubsystemAdd() {
        super(Namespace.CURRENT.getUriString());
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        String defaultHost = this.defaultHost != null ? this.defaultHost : "localhost";
        WebServerService service = new WebServerService(defaultHost);
        context.getBatchBuilder().addService(WebSubsystemElement.JBOSS_WEB, (Service)service).addDependency(AbstractPathService.pathNameOf((String)BASE_DIR), String.class, service.getPathInjector()).addOptionalDependency(ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, service.getMbeanServer()).addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(resultHandler, param)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        WebDeploymentActivator.activate(defaultHost, new SharedWebMetaDataBuilder(this.config), new SharedTldsMetaDataBuilder(this.config), context.getBatchBuilder());
    }

    protected WebSubsystemElement createSubsystemElement() {
        WebSubsystemElement element = new WebSubsystemElement(this.defaultHost);
        element.setConfig(this.config);
        return element;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    public WebContainerConfigElement getConfig() {
        return this.config;
    }

    public void setConfig(WebContainerConfigElement config) {
        this.config = config;
    }
}

