/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.web.deployment.WarStructureDeploymentProcessor;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class WarAnnotationIndex {
    private final Index rootIndex;
    private final Map<String, Index> indexes = new HashMap<String, Index>();

    private WarAnnotationIndex(Index root) {
        this.rootIndex = root;
    }

    static WarAnnotationIndex create(VirtualFile deploymentRoot) throws DeploymentUnitProcessingException {
        WarAnnotationIndex annotationIndex = new WarAnnotationIndex(WarAnnotationIndex.createRoot(deploymentRoot));
        WarAnnotationIndex.processLibs(deploymentRoot, annotationIndex.indexes);
        return annotationIndex;
    }

    public Index getRootIndex() {
        return this.rootIndex;
    }

    public Collection<String> getPathNames() {
        return this.indexes.keySet();
    }

    public Index getIndex(String pathName) {
        if (pathName == null || pathName.equals("")) {
            return this.getRootIndex();
        }
        return this.indexes.get(pathName);
    }

    public List<AnnotationTarget> getAnnotationTargets(DotName annotationName) {
        ArrayList<AnnotationTarget> list = new ArrayList<AnnotationTarget>();
        if (this.rootIndex != null) {
            list.addAll(this.rootIndex.getAnnotationTargets(annotationName));
        }
        for (Index index : this.indexes.values()) {
            list.addAll(index.getAnnotationTargets(annotationName));
        }
        return list;
    }

    public List<ClassInfo> getKnownSubclasses(DotName className) {
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
        if (this.rootIndex != null) {
            list.addAll(this.rootIndex.getKnownSubclasses(className));
        }
        for (Index index : this.indexes.values()) {
            list.addAll(index.getKnownSubclasses(className));
        }
        return list;
    }

    public ClassInfo getClassByName(DotName className) {
        ClassInfo info = null;
        if (this.rootIndex != null) {
            info = this.rootIndex.getClassByName(className);
        }
        if (info == null) {
            for (Index index : this.indexes.values()) {
                info = index.getClassByName(className);
                if (info == null) continue;
                return info;
            }
        }
        return info;
    }

    public Collection<ClassInfo> getKnownClasses() {
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
        if (this.rootIndex != null) {
            list.addAll(this.rootIndex.getKnownClasses());
        }
        for (Index index : this.indexes.values()) {
            list.addAll(index.getKnownClasses());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processLibs(VirtualFile deploymentRoot, Map<String, Index> indexes) throws DeploymentUnitProcessingException {
        VirtualFile webInfLib = deploymentRoot.getChild("WEB-INF/lib");
        if (webInfLib.exists()) {
            try {
                List archives = webInfLib.getChildren(WarStructureDeploymentProcessor.DEFAULT_WEB_INF_LIB_FILTER);
                for (VirtualFile archive : archives) {
                    Indexer indexer = new Indexer();
                    List classChildren = archive.getChildren((VirtualFileFilter)new SuffixMatchFilter(".class", VisitorAttributes.RECURSE_LEAVES_ONLY));
                    for (VirtualFile classFile : classChildren) {
                        InputStream inputStream = null;
                        try {
                            inputStream = classFile.openStream();
                            indexer.index(inputStream);
                        }
                        finally {
                            VFSUtils.safeClose((Closeable)inputStream);
                        }
                    }
                    indexes.put(archive.getName(), indexer.complete());
                }
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to index deployment root for annotations");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Index createRoot(VirtualFile deploymentRoot) throws DeploymentUnitProcessingException {
        VirtualFile classes = deploymentRoot.getChild("WEB-INF/classes");
        if (classes.exists()) {
            Indexer indexer = new Indexer();
            try {
                List classChildren = classes.getChildren((VirtualFileFilter)new SuffixMatchFilter(".class", VisitorAttributes.RECURSE_LEAVES_ONLY));
                for (VirtualFile classFile : classChildren) {
                    InputStream inputStream = null;
                    try {
                        inputStream = classFile.openStream();
                        indexer.index(inputStream);
                    }
                    finally {
                        VFSUtils.safeClose((Closeable)inputStream);
                    }
                }
                return indexer.complete();
            }
            catch (Throwable t) {
                throw new DeploymentUnitProcessingException("Failed to index deployment root for annotations", t);
            }
        }
        return null;
    }
}

