/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.metadata.parser.servlet.WebFragmentMetaDataParser;
import org.jboss.as.metadata.parser.util.NoopXmlResolver;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.helpers.DeploymentStructure;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.vfs.VirtualFile;

public class WebFragmentParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(310L);
    private static final String WEB_FRAGMENT_XML = "META-INF/web-fragment.xml";

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        WarMetaData warMetaData = (WarMetaData)context.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        Map<String, WebFragmentMetaData> webFragments = warMetaData.getWebFragmentsMetaData();
        if (webFragments == null) {
            webFragments = new HashMap<String, WebFragmentMetaData>();
            warMetaData.setWebFragmentsMetaData(webFragments);
        }
        DeploymentStructure structure = (DeploymentStructure)context.getAttachment(DeploymentStructure.ATTACHMENT_KEY);
        assert (structure != null);
        assert (structure.getEntries() != null);
        for (DeploymentStructure.ClassPathEntry resourceRoot : structure.getEntries()) {
            VirtualFile webFragment;
            if (!resourceRoot.getRoot().getLowerCaseName().endsWith(".jar") || !(webFragment = resourceRoot.getRoot().getChild(WEB_FRAGMENT_XML)).exists() || !webFragment.isFile()) continue;
            InputStream is = null;
            try {
                is = webFragment.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setXMLResolver(NoopXmlResolver.create());
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                webFragments.put(resourceRoot.getName(), WebFragmentMetaDataParser.parse(xmlReader));
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to parse " + webFragment, (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }
}

