/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.helpers;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.as.deployment.AttachmentKey;
import org.jboss.as.deployment.module.MountHandle;
import org.jboss.vfs.VirtualFile;

public class DeploymentStructure {
    public static final AttachmentKey<DeploymentStructure> ATTACHMENT_KEY = AttachmentKey.create(DeploymentStructure.class);
    private final ClassPathEntry[] entries;

    public DeploymentStructure(ClassPathEntry[] entries) {
        this.entries = entries;
    }

    public ClassPathEntry[] getEntries() {
        return this.entries;
    }

    public static class ClassPathEntry
    implements Closeable {
        private final String name;
        private final VirtualFile root;
        private final Closeable closeable;
        private final MountHandle mountHandle;

        public ClassPathEntry(VirtualFile root, Closeable closeable) {
            this(root.getName(), root, closeable);
        }

        public ClassPathEntry(String name, VirtualFile root, Closeable closeable) {
            this.name = name;
            this.root = root;
            this.closeable = closeable;
            this.mountHandle = new MountHandle(closeable);
        }

        public ClassPathEntry(String name, VirtualFile root, MountHandle handle) {
            this.name = name;
            this.root = root;
            this.closeable = null;
            this.mountHandle = new MountHandle(null);
        }

        public String getName() {
            return this.name;
        }

        public VirtualFile getRoot() {
            return this.root;
        }

        public MountHandle getMountHandle() {
            return this.mountHandle;
        }

        @Override
        public void close() throws IOException {
            if (this.closeable != null) {
                this.closeable.close();
            }
        }
    }
}

