/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.jandex.Index;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public final class WSDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier ASIL = ModuleIdentifier.create((String)"org.jboss.as.webservices.server.integration");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!this.isWSDeployment(deploymentUnit)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleDependency asilDependency = new ModuleDependency(moduleLoader, ASIL, false, true, true);
        ModuleDependency hackyDependency = WSDependenciesProcessor.applyCXFExtensionImportFilters(asilDependency);
        moduleSpecification.addDependency(hackyDependency);
    }

    private static ModuleDependency applyCXFExtensionImportFilters(ModuleDependency dep) {
        dep.addImportFilter(PathFilters.match((String)"META-INF/cxf"), true);
        dep.addImportFilter(PathFilters.match((String)"META-INF/spring.*"), true);
        return dep;
    }

    private boolean isWSDeployment(DeploymentUnit unit) {
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit)) {
            return false;
        }
        Index index = ASHelper.getRootAnnotationIndex(unit);
        WarMetaData warMetaData = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null || warMetaData.getWebMetaData() == null) {
            return false;
        }
        return ASHelper.selectWebServiceServlets(index, warMetaData.getWebMetaData().getServlets(), true).size() > 0;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

