/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.webservices.deployers.WSEJBAdapterDeployer;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;

public final class WSDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final Logger LOGGER = Logger.getLogger(WSDependenciesProcessor.class);
    public static final ModuleIdentifier ASIL = ModuleIdentifier.create((String)"org.jboss.as.webservices.server.integration");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!this.isWSDeployment(deploymentUnit)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addDependency(WSDependenciesProcessor.applyCXFExtensionImportFilters(new ModuleDependency(moduleLoader, ASIL, false, true, true)));
    }

    private static ModuleDependency applyCXFExtensionImportFilters(ModuleDependency dep) {
        dep.addImportFilter(PathFilters.match((String)"META-INF/cxf"), true);
        dep.addImportFilter(PathFilters.match((String)"META-INF"), true);
        return dep;
    }

    private boolean isJaxwsJseDeployment(DeploymentUnit unit) {
        boolean isWarDeployment = DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit);
        if (isWarDeployment) {
            Index index = ASHelper.getRootAnnotationIndex(unit);
            WarMetaData warMetaData = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
            if (warMetaData != null && warMetaData.getWebMetaData() != null) {
                return ASHelper.selectWebServiceServlets(index, warMetaData.getWebMetaData().getServlets(), true).size() > 0;
            }
        }
        return false;
    }

    private boolean isJaxwsEjbDeployment(DeploymentUnit unit) {
        boolean isEjbDeployment = EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)unit);
        if (isEjbDeployment) {
            WSEJBAdapterDeployer.internalDeploy(unit);
            WebServiceDeployment wsDeployment = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY);
            return wsDeployment.getServiceEndpoints().size() > 0;
        }
        return false;
    }

    private boolean isWSDeployment(DeploymentUnit unit) {
        if (this.isJaxwsJseDeployment(unit)) {
            LOGGER.trace((Object)"Detected JAXWS JSE deployment");
            return true;
        }
        if (this.isJaxwsEjbDeployment(unit)) {
            LOGGER.trace((Object)"Detected JAXWS EJB3 deployment");
            return true;
        }
        return false;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

