/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.deployers.SecurityActions;
import org.jboss.as.webservices.deployers.TCCLDeploymentProcessor;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

public final class AspectDeploymentProcessor
extends TCCLDeploymentProcessor
implements DeploymentUnitProcessor {
    private static Logger log = Logger.getLogger(AspectDeploymentProcessor.class);
    private Class<? extends DeploymentAspect> clazz;
    private String aspectClass;
    private DeploymentAspect aspect;

    public AspectDeploymentProcessor(Class<? extends DeploymentAspect> aspectClass) {
        this.clazz = aspectClass;
    }

    public AspectDeploymentProcessor(String aspectClass) {
        this.aspectClass = aspectClass;
    }

    public AspectDeploymentProcessor(DeploymentAspect aspect) {
        this.aspect = aspect;
    }

    @Override
    public void internalDeploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (ASHelper.isWebServiceDeployment(unit)) {
            if (this.aspect == null) {
                try {
                    if (this.clazz == null) {
                        this.clazz = SecurityActions.getContextClassLoader().loadClass(this.aspectClass);
                    }
                    this.aspect = this.clazz.newInstance();
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException((Throwable)e);
                }
            }
            log.debug((Object)(this.aspect + " start: " + unit.getName()));
            Deployment dep = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.DEPLOYMENT_KEY);
            this.aspect.start(dep);
        }
    }

    @Override
    public void internalUndeploy(DeploymentUnit context) {
        if (ASHelper.isWebServiceDeployment(context)) {
            log.debug((Object)(this.aspect + " stop: " + context.getName()));
            Deployment dep = ASHelper.getRequiredAttachment(context, WSAttachmentKeys.DEPLOYMENT_KEY);
            this.aspect.stop(dep);
        }
    }
}

