/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.webservices.deployers.AspectDeploymentProcessor;
import org.jboss.as.webservices.deployers.WSDependenciesProcessor;
import org.jboss.as.webservices.deployers.WSDescriptorDeploymentProcessor;
import org.jboss.as.webservices.deployers.WSModelDeploymentProcessor;
import org.jboss.as.webservices.deployers.WSTypeDeploymentProcessor;
import org.jboss.as.webservices.deployers.WebServiceContextDeploymentUnitProcessor;
import org.jboss.as.webservices.parser.WSDeploymentAspectParser;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.sort.DeploymentAspectSorter;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

final class WSDeploymentActivator {
    private static final Logger LOGGER = Logger.getLogger(WSDeploymentActivator.class);

    WSDeploymentActivator() {
    }

    static void activate(BootOperationContext updateContext) {
        int priority = 1802;
        updateContext.addDeploymentProcessor(Phase.PARSE, 11264, (DeploymentUnitProcessor)new WSDescriptorDeploymentProcessor());
        updateContext.addDeploymentProcessor(Phase.DEPENDENCIES, 3072, (DeploymentUnitProcessor)new WSDependenciesProcessor());
        updateContext.addDeploymentProcessor(Phase.INSTALL, 3328, (DeploymentUnitProcessor)new WebServiceContextDeploymentUnitProcessor());
        updateContext.addDeploymentProcessor(Phase.INSTALL, priority++, (DeploymentUnitProcessor)new WSTypeDeploymentProcessor());
        updateContext.addDeploymentProcessor(Phase.INSTALL, priority++, (DeploymentUnitProcessor)new WSModelDeploymentProcessor());
        WSDeploymentActivator.addDeploymentProcessors(updateContext, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<DeploymentAspect> getDeploymentAspects(ClassLoader cl, String resourcePath) {
        List<DeploymentAspect> list;
        Enumeration<URL> urls = WSDeploymentActivator.class.getClassLoader().getResources(resourcePath);
        if (urls == null) throw new RuntimeException("Could not load WS deployment aspects from " + resourcePath);
        URL url = urls.nextElement();
        InputStream is = null;
        try {
            is = url.openStream();
            list = WSDeploymentAspectParser.parse(is, cl);
            if (is == null) return list;
        }
        catch (Throwable throwable) {
            try {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load WS deployment aspects from " + resourcePath, e);
            }
        }
        try {
            is.close();
            return list;
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    private static void addDeploymentProcessors(BootOperationContext updateContext, int priority) {
        int index = 1;
        for (DeploymentAspect da : WSDeploymentActivator.getSortedDeploymentAspects()) {
            LOGGER.tracef("Installing aspect %s", (Object)da.getClass().getName());
            updateContext.addDeploymentProcessor(Phase.INSTALL, priority + index++, (DeploymentUnitProcessor)new AspectDeploymentProcessor(da));
        }
    }

    private static List<DeploymentAspect> getSortedDeploymentAspects() {
        LinkedList<DeploymentAspect> deploymentAspects = new LinkedList<DeploymentAspect>();
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        deploymentAspects.addAll(WSDeploymentActivator.getDeploymentAspects(cl, "/META-INF/stack-agnostic-deployment-aspects.xml"));
        deploymentAspects.addAll(WSDeploymentActivator.getDeploymentAspects(cl, "/META-INF/stack-specific-deployment-aspects.xml"));
        return DeploymentAspectSorter.getInstance().sort(deploymentAspects);
    }
}

