/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.webservices.dmr.EndpointConfigAdd;
import org.jboss.as.webservices.dmr.EndpointConfigRemove;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.as.webservices.dmr.WSEndpointMetrics;
import org.jboss.as.webservices.dmr.WSSubsystemAdd;
import org.jboss.as.webservices.dmr.WSSubsystemDescribe;
import org.jboss.as.webservices.dmr.WSSubsystemProviders;
import org.jboss.as.webservices.dmr.WebservicesSubsystemParser;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public final class WSExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "webservices";

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebservicesSubsystemParser.getInstance());
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(WSSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)WSSubsystemAdd.INSTANCE, WSSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)WSSubsystemDescribe.INSTANCE, WSSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, WSSubsystemProviders.SUBSYSTEM_REMOVE, false);
        ManagementResourceRegistration epConfigs = registration.registerSubModel(PathElement.pathElement((String)"endpoint-config"), WSSubsystemProviders.ENDPOINTCONFIG_DESCRIPTION);
        epConfigs.registerOperationHandler("add", (OperationStepHandler)EndpointConfigAdd.INSTANCE, WSSubsystemProviders.ENDPOINTCONFIG_ADD_DESCRIPTION, false);
        epConfigs.registerOperationHandler("remove", (OperationStepHandler)EndpointConfigRemove.INSTANCE, WSSubsystemProviders.ENDPOINTCONFIG_REMOVE_DESCRIPTION, false);
        ManagementResourceRegistration deployments = subsystem.registerDeploymentModel(WSSubsystemProviders.DEPLOYMENT_DESCRIPTION);
        ManagementResourceRegistration endpoints = deployments.registerSubModel(PathElement.pathElement((String)"endpoint"), WSSubsystemProviders.ENDPOINT_DESCRIPTION);
        for (String attributeName : WSEndpointMetrics.ATTRIBUTES) {
            endpoints.registerMetric(attributeName, (OperationStepHandler)WSEndpointMetrics.INSTANCE);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)WebservicesSubsystemParser.getInstance());
    }
}

