/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.as.webservices.util.WebAppController;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.ServerConfig;

public final class PortComponentLinkService
implements Service<WebAppController> {
    private final ServiceName name;
    private final InjectedValue<VirtualHost> hostInjector = new InjectedValue();
    private volatile WebAppController pclwa;
    private final InjectedValue<ServerConfig> serverConfigInjectorValue = new InjectedValue();
    private static final String DEFAULT_HOST_NAME = "default-host";

    private PortComponentLinkService() {
        this.name = WSServices.PORT_COMPONENT_LINK_SERVICE;
    }

    public WebAppController getValue() {
        return this.pclwa;
    }

    public ServiceName getName() {
        return this.name;
    }

    public InjectedValue<VirtualHost> getHostInjector() {
        return this.hostInjector;
    }

    public void start(StartContext ctx) throws StartException {
        WSLogger.ROOT_LOGGER.starting(this.name);
        String serverTempDir = ((ServerConfig)this.serverConfigInjectorValue.getValue()).getServerTempDir().getAbsolutePath();
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerJAXRPCIntegrationClassLoader();
        this.pclwa = new WebAppController(((VirtualHost)this.hostInjector.getValue()).getHost(), "org.jboss.ws.core.server.PortComponentLinkServlet", cl, "/jbossws", "/pclink", serverTempDir);
    }

    public void stop(StopContext ctx) {
        WSLogger.ROOT_LOGGER.stopping(this.name);
        this.pclwa = null;
    }

    public Injector<ServerConfig> getServerConfigInjector() {
        return this.serverConfigInjectorValue;
    }

    public static ServiceBuilder<WebAppController> createServiceBuilder(ServiceTarget serviceTarget, String hostName) {
        PortComponentLinkService service = new PortComponentLinkService();
        ServiceBuilder builder = serviceTarget.addService(service.getName(), (Service)service);
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, WSServices.REGISTRY_SERVICE);
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, WSServices.CONFIG_SERVICE, ServerConfig.class, service.getServerConfigInjector());
        builder.addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName}), VirtualHost.class, service.getHostInjector());
        return builder;
    }

    public static ServiceController<WebAppController> install(ServiceTarget serviceTarget, ServiceListener<Object> ... listeners) {
        return PortComponentLinkService.install(serviceTarget, DEFAULT_HOST_NAME, listeners);
    }

    public static ServiceController<WebAppController> install(ServiceTarget serviceTarget, String hostName, ServiceListener<Object> ... listeners) {
        ServiceBuilder<WebAppController> builder = PortComponentLinkService.createServiceBuilder(serviceTarget, hostName);
        builder.addListener(listeners);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }
}

