/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.deployers.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.utils.InjectionUtils;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.VirtualFileAdaptor;
import org.jboss.as.webservices.webserviceref.WSRefUtils;
import org.jboss.as.webservices.webserviceref.WSRefValueSource;
import org.jboss.as.webservices.webserviceref.WSReferences;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
import org.jboss.modules.Module;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public final class WSRefDDProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit unit, DeploymentDescriptorEnvironment environment, ResourceInjectionTarget resourceInjectionTarget, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ServiceReferencesMetaData serviceRefsMD = environment.getEnvironment().getServiceReferences();
        if (serviceRefsMD == null) {
            return Collections.emptyList();
        }
        LinkedList<BindingConfiguration> bindingDescriptions = new LinkedList<BindingConfiguration>();
        for (ServiceReferenceMetaData serviceRefMD : serviceRefsMD) {
            UnifiedServiceRefMetaData serviceRefUMDM = WSRefDDProcessor.getServiceRef(unit, componentDescription, serviceRefMD);
            WSRefValueSource valueSource = new WSRefValueSource(serviceRefUMDM);
            BindingConfiguration bindingConfiguration = new BindingConfiguration(serviceRefUMDM.getServiceRefName(), (InjectionSource)valueSource);
            bindingDescriptions.add(bindingConfiguration);
            String serviceRefTypeName = serviceRefUMDM.getServiceRefType();
            Class<?> serviceRefType = this.getClass(classLoader, serviceRefTypeName);
            this.processInjectionTargets(resourceInjectionTarget, valueSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)serviceRefMD, serviceRefType);
        }
        return bindingDescriptions;
    }

    private static UnifiedServiceRefMetaData getServiceRef(DeploymentUnit unit, ComponentDescription componentDescription, ServiceReferenceMetaData serviceRefMD) throws DeploymentUnitProcessingException {
        UnifiedServiceRefMetaData serviceRefUMDM = new UnifiedServiceRefMetaData(WSRefDDProcessor.getUnifiedVirtualFile(unit));
        WSRefUtils.translate(serviceRefMD, serviceRefUMDM);
        WSRefDDProcessor.processWSFeatures(unit, serviceRefMD.getInjectionTargets(), serviceRefUMDM);
        WSReferences wsRefRegistry = ASHelper.getWSRefRegistry(unit);
        String cacheKey = WSRefDDProcessor.getCacheKey(componentDescription, serviceRefUMDM);
        wsRefRegistry.add(cacheKey, serviceRefUMDM);
        return serviceRefUMDM;
    }

    private static String getCacheKey(ComponentDescription componentDescription, UnifiedServiceRefMetaData serviceRefUMMD) {
        if (componentDescription == null) {
            return serviceRefUMMD.getServiceRefName();
        }
        return componentDescription.getComponentName() + "/" + serviceRefUMMD.getServiceRefName();
    }

    private static void processWSFeatures(DeploymentUnit unit, Set<ResourceInjectionTargetMetaData> injectionTargets, UnifiedServiceRefMetaData serviceRefUMDM) throws DeploymentUnitProcessingException {
        if (injectionTargets == null || injectionTargets.size() == 0) {
            return;
        }
        if (injectionTargets.size() > 1) {
            // empty if block
        }
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)unit.getAttachment(Attachments.REFLECTION_INDEX);
        ResourceInjectionTargetMetaData injectionTarget = injectionTargets.iterator().next();
        String injectionTargetClassName = injectionTarget.getInjectionTargetClass();
        String injectionTargetName = injectionTarget.getInjectionTargetName();
        AccessibleObject fieldOrMethod = InjectionUtils.getInjectionTarget((String)injectionTargetClassName, (String)injectionTargetName, (ClassLoader)module.getClassLoader(), (DeploymentReflectionIndex)deploymentReflectionIndex);
        WSRefUtils.processAnnotatedElement(fieldOrMethod, serviceRefUMDM);
    }

    private Class<?> getClass(ClassLoader classLoader, String className) throws DeploymentUnitProcessingException {
        if (!WSRefDDProcessor.isEmpty(className)) {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
        return null;
    }

    private static UnifiedVirtualFile getUnifiedVirtualFile(DeploymentUnit deploymentUnit) {
        ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        return new VirtualFileAdaptor(resourceRoot.getRoot());
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

