/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.protocol.ietf00;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.websockets.AbstractWebSocket;
import org.jboss.as.websockets.WebSocket;
import org.jboss.servlet.http.HttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hybi00Socket
extends AbstractWebSocket {
    private final HttpEvent event;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private static final Logger log = LoggerFactory.getLogger(Hybi00Socket.class);

    private Hybi00Socket(HttpEvent event, InputStream inputStream, OutputStream outputStream) {
        this.event = event;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public static WebSocket from(HttpEvent event) throws IOException {
        return new Hybi00Socket(event, (InputStream)event.getHttpServletRequest().getInputStream(), (OutputStream)event.getHttpServletResponse().getOutputStream());
    }

    public void writeTextFrame(String text) throws IOException {
        byte[] bytes = text.getBytes("UTF-8");
        this.outputStream.write(0);
        for (byte aByte : bytes) {
            this.outputStream.write(aByte);
        }
        this.outputStream.write(-1);
        System.out.println("WriteTextFrame:" + text);
    }

    public String readTextFrame() throws IOException {
        byte frametype = (byte)this.inputStream.read();
        boolean error = false;
        System.out.println("FrameType=" + frametype);
        if ((frametype & 0x80) == 128) {
            int length = 0;
            int b = this.inputStream.read();
            int b_v = b & 0x7F;
            length = length * 128 + b_v;
            if ((b & 0x80) != 128) {
                for (int i = 0; i < length; ++i) {
                    this.inputStream.read();
                }
            }
            if (frametype == 255 && length == 0) {
                error = true;
            }
        } else if ((frametype & 0x80) == 0) {
            int b;
            System.out.println("TextFrame");
            StringBuilder buf = new StringBuilder();
            while ((b = this.inputStream.read()) != 255) {
                buf.append((char)b);
            }
            System.out.println("BufferData:" + buf.toString());
            if (frametype == 0) {
                return buf.toString();
            }
            error = true;
        }
        if (error) {
            throw new RuntimeException("bad websockets payload");
        }
        return "";
    }
}

