/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.protocol.ietf07;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.jboss.as.websockets.AbstractWebSocket;
import org.jboss.as.websockets.WebSocket;
import org.jboss.servlet.http.HttpEvent;

public class Hybi07Socket
extends AbstractWebSocket {
    private final HttpEvent event;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private static final byte FRAME_FIN = -128;
    private static final byte FRAME_OPCODE = 127;
    private static final byte FRAME_MASKED = -128;
    private static final byte FRAME_LENGTH = 127;
    private static final int OPCODE_CONTINUATION = 0;
    private static final int OPCODE_TEXT = 1;
    private static final int OPCODE_BINARY = 2;
    private static final int OPCODE_CONNECTION_CLOSE = 3;
    private static final int OPCODE_PING = 4;
    private static final int OPCODE_PONG = 5;
    private static final String secureRandomAlgorithm = "SHA1PRNG";
    static final SecureRandom random;

    public Hybi07Socket(HttpEvent event, InputStream inputStream, OutputStream outputStream) {
        this.event = event;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public static WebSocket from(HttpEvent event) throws IOException {
        return new Hybi07Socket(event, (InputStream)event.getHttpServletRequest().getInputStream(), (OutputStream)event.getHttpServletResponse().getOutputStream());
    }

    private String _readTextFrame() throws IOException {
        int b = this.inputStream.read();
        int opcode = b & 0x7F;
        b = this.inputStream.read();
        boolean frameMasked = (b & 0xFFFFFF80) != 0;
        int payloadLength = b & 0x7F;
        if (payloadLength == 126) {
            payloadLength = ((this.inputStream.read() & 0xFF) << 8) + (this.inputStream.read() & 0xFF);
        } else if (payloadLength == 127) {
            this.inputStream.read();
            this.inputStream.read();
            this.inputStream.read();
            this.inputStream.read();
            payloadLength = ((this.inputStream.read() & 0xFF) << 24) + ((this.inputStream.read() & 0xFF) << 16) + ((this.inputStream.read() & 0xFF) << 8) + (this.inputStream.read() & 0xFF);
        }
        byte[] frameMaskingKey = new byte[4];
        if (frameMasked) {
            this.inputStream.read(frameMaskingKey);
        }
        StringBuilder payloadBuffer = new StringBuilder(payloadLength);
        switch (opcode) {
            case 1: {
                int read = 0;
                if (frameMasked) {
                    do {
                        payloadBuffer.append((char)((this.inputStream.read() ^ frameMaskingKey[read % 4]) & 0x7F));
                    } while (++read < payloadLength);
                    break;
                }
                do {
                    payloadBuffer.append((char)this.inputStream.read());
                } while (++read < payloadLength);
                break;
            }
            case 3: {
                this.event.close();
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                throw new RuntimeException("binary frame not yet supported");
            }
        }
        return payloadBuffer.toString();
    }

    private void _writeTextFrame(String txt) throws IOException {
        byte[] strBytes = txt.getBytes("UTF-8");
        this.outputStream.write(-127);
        if (strBytes.length > Short.MAX_VALUE) {
            this.outputStream.write(-1);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write((strBytes.length & 0xFF) << 24);
            this.outputStream.write((strBytes.length & 0xFF) << 16);
            this.outputStream.write((strBytes.length & 0xFF) << 8);
            this.outputStream.write(strBytes.length & 0xFF);
        } else if (strBytes.length > 125) {
            this.outputStream.write(-2);
            this.outputStream.write(strBytes.length >> 8 & 0xFF);
            this.outputStream.write(strBytes.length & 0xFF);
        } else {
            this.outputStream.write(0xFFFFFF80 | strBytes.length & 0x7F);
        }
        byte[] mask = new byte[4];
        random.nextBytes(mask);
        this.outputStream.write(mask);
        int len = strBytes.length;
        for (int j = 0; j < len; ++j) {
            this.outputStream.write(strBytes[j] ^ mask[j % 4]);
        }
        this.outputStream.flush();
    }

    public void writeTextFrame(String text) throws IOException {
        this._writeTextFrame(text);
    }

    public String readTextFrame() throws IOException {
        return this._readTextFrame();
    }

    static {
        try {
            random = SecureRandom.getInstance(secureRandomAlgorithm);
            random.setSeed(SecureRandom.getInstance(secureRandomAlgorithm).generateSeed(64));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("runtime does not support secure random algorithm: SHA1PRNG");
        }
    }
}

