/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.protocol.ietf00;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.websockets.Handshake;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.WebSocketHeaders;
import org.jboss.as.websockets.protocol.ietf00.Hybi00Socket;
import org.jboss.servlet.http.HttpEvent;

public class Hybi00Handshake
extends Handshake {
    public Hybi00Handshake() {
        super("0", "MD5", null);
    }

    public boolean matches(HttpServletRequest request) {
        return WebSocketHeaders.SEC_WEBSOCKET_KEY1.isIn(request) && WebSocketHeaders.SEC_WEBSOCKET_KEY2.isIn(request);
    }

    public WebSocket getWebSocket(HttpEvent event) throws IOException {
        return Hybi00Socket.from(event);
    }

    public byte[] generateResponse(HttpEvent event) throws IOException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        if (WebSocketHeaders.ORIGIN.isIn(request)) {
            WebSocketHeaders.SEC_WEBSOCKET_ORIGIN.set(response, WebSocketHeaders.ORIGIN.get(request).trim());
        }
        String origin = "ws://" + request.getHeader("Host") + request.getRequestURI();
        WebSocketHeaders.SEC_WEBSOCKET_LOCATION.set(response, origin);
        WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.copy(request, response);
        String key1 = WebSocketHeaders.SEC_WEBSOCKET_KEY1.get(request);
        String key2 = WebSocketHeaders.SEC_WEBSOCKET_KEY2.get(request);
        byte[] key3 = new byte[8];
        ServletInputStream inputStream = request.getInputStream();
        inputStream.read(key3);
        byte[] solution = Hybi00Handshake.solve(this.getHashAlgorithm(), key1, key2, key3);
        return solution;
    }

    public static byte[] solve(String hashAlgorithm, String encodedKey1, String encodedKey2, byte[] key3) {
        return Hybi00Handshake.solve(hashAlgorithm, Hybi00Handshake.decodeKey(encodedKey1), Hybi00Handshake.decodeKey(encodedKey2), key3);
    }

    public static byte[] solve(String hashAlgorithm, long key1, long key2, byte[] key3) {
        ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt((int)key1);
        buffer.putInt((int)key2);
        buffer.put(key3);
        byte[] solution = new byte[16];
        buffer.rewind();
        buffer.get(solution, 0, 16);
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
            return digest.digest(solution);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("error generating hash", e);
        }
    }

    public static long decodeKey(String encoded) {
        int len = encoded.length();
        int numSpaces = 0;
        for (int i = 0; i < len; ++i) {
            if (encoded.charAt(i) != ' ') continue;
            ++numSpaces;
        }
        String digits = encoded.replaceAll("[^0-9]", "");
        long product = Long.parseLong(digits);
        return product / (long)numSpaces;
    }
}

