/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.protocol.ietf00;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.websockets.AbstractWebSocket;
import org.jboss.as.websockets.WebSocket;
import org.jboss.servlet.http.HttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hybi00Socket
extends AbstractWebSocket {
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final int MAX_FRAME_SIZE = 32768;
    private static final Logger log = LoggerFactory.getLogger(Hybi00Socket.class);

    private Hybi00Socket(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public static WebSocket from(HttpEvent event) throws IOException {
        return new Hybi00Socket((InputStream)event.getHttpServletRequest().getInputStream(), (OutputStream)event.getHttpServletResponse().getOutputStream());
    }

    public void writeTextFrame(String text) throws IOException {
        this.outputStream.write(0);
        this.outputStream.write(text.getBytes("UTF-8"));
        this.outputStream.write(-1);
        this.outputStream.flush();
    }

    public String readTextFrame() throws IOException {
        byte frametype = (byte)this.inputStream.read();
        if ((frametype & 0x80) == 128) {
            throw new RuntimeException("binary payload not supported");
        }
        if (frametype == 0) {
            int b;
            StringBuilder buf = new StringBuilder();
            int read = 0;
            while ((b = this.inputStream.read()) != 255) {
                if (++read > 32768) {
                    throw new RuntimeException("frame too large");
                }
                buf.append((char)b);
            }
            return buf.toString();
        }
        throw new RuntimeException("bad websockets payload");
    }
}

