/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.protocol.ClosingStrategy;
import org.jboss.as.websockets.util.Assert;
import org.jboss.as.websockets.util.Hash;

public abstract class AbstractWebSocket
implements WebSocket {
    protected final String webSocketId = Hash.newUniqueHash();
    protected final HttpServletRequest servletRequest;
    protected final InputStream inputStream;
    protected final OutputStream outputStream;
    protected final ClosingStrategy closingStrategy;

    protected AbstractWebSocket(HttpServletRequest servletRequest, InputStream inputStream, OutputStream outputStream, ClosingStrategy closingStrategy) {
        this.servletRequest = Assert.notNull(servletRequest, "servletRequest must NOT be null");
        this.inputStream = Assert.notNull(inputStream, "inputStream must NOT be null");
        this.outputStream = Assert.notNull(outputStream, "outputStream must NOT be null");
        this.closingStrategy = Assert.notNull(closingStrategy, "closingStrategy must NOT be null");
    }

    public final String getSocketID() {
        return this.webSocketId;
    }

    public HttpSession getHttpSession() {
        return this.servletRequest.getSession();
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public void closeSocket() throws IOException {
        this.closingStrategy.doClose();
    }
}

