/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.protocol.ClosingStrategy;
import org.jboss.servlet.http.HttpEvent;

public abstract class Handshake {
    private final String version;
    private final String hashAlgorithm;
    private final String magicNumber;

    public Handshake(String version, String hashAlgorithm, String magicNumber) {
        this.version = version;
        this.hashAlgorithm = hashAlgorithm;
        this.magicNumber = magicNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getMagicNumber() {
        return this.magicNumber;
    }

    protected String getWebSocketLocation(HttpServletRequest request) {
        return "ws://" + request.getHeader("Host") + request.getRequestURI();
    }

    public abstract WebSocket getWebSocket(HttpServletRequest var1, HttpServletResponse var2, ClosingStrategy var3) throws IOException;

    public abstract boolean matches(HttpServletRequest var1);

    public abstract byte[] generateResponse(HttpEvent var1) throws IOException;
}

