/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.protocol.ietf13;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.WebSocketHeaders;
import org.jboss.as.websockets.protocol.ClosingStrategy;
import org.jboss.as.websockets.protocol.ietf07.Hybi07Handshake;
import org.jboss.as.websockets.protocol.ietf13.Hybi13Socket;
import org.jboss.servlet.http.HttpEvent;

public class Hybi13Handshake
extends Hybi07Handshake {
    public Hybi13Handshake() {
        super("13");
    }

    public WebSocket getWebSocket(HttpServletRequest request, HttpServletResponse response, ClosingStrategy closingStrategy) throws IOException {
        return Hybi13Socket.from(request, response, closingStrategy);
    }

    public byte[] generateResponse(HttpEvent event) throws IOException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        WebSocketHeaders.ORIGIN.copy(request, response);
        WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.copy(request, response);
        WebSocketHeaders.SEC_WEBSOCKET_LOCATION.set(response, this.getWebSocketLocation(request));
        String key = WebSocketHeaders.SEC_WEBSOCKET_KEY.get(request);
        String solution = this.solve(key);
        WebSocketHeaders.SEC_WEBSOCKET_ACCEPT.set(response, solution);
        return new byte[0];
    }
}

