/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.websockets.Handshake;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.WebSocketHeaders;
import org.jboss.as.websockets.protocol.ClosingStrategy;
import org.jboss.as.websockets.protocol.ietf00.Hybi00Handshake;
import org.jboss.as.websockets.protocol.ietf07.Hybi07Handshake;
import org.jboss.as.websockets.protocol.ietf08.Hybi08Handshake;
import org.jboss.as.websockets.protocol.ietf13.Hybi13Handshake;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.jboss.servlet.http.UpgradableHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketServlet
extends HttpServlet
implements HttpEventServlet {
    private static final List<Handshake> websocketHandshakes;
    private static final Logger log;
    private final String protocolName;
    private static final String SESSION_WEBSOCKET_HANDLE = "JBoss:AS:WebSocket:Handle";

    protected WebSocketServlet(String protocolName) {
        this.protocolName = protocolName;
    }

    protected WebSocketServlet() {
        this.protocolName = null;
    }

    private void setStandardUpgradeHeaders(HttpServletResponse response) {
        response.setHeader("Upgrade", "WebSocket");
        response.setHeader("Connection", "Upgrade");
        if (this.protocolName != null) {
            WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.set(response, this.protocolName);
        } else {
            WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.set(response, "*");
        }
    }

    public final void event(final HttpEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        switch (event.getType()) {
            case BEGIN: {
                event.setTimeout(20000);
                if (response instanceof UpgradableHttpServletResponse) {
                    for (Handshake handshake : websocketHandshakes) {
                        if (!handshake.matches(request)) continue;
                        ((UpgradableHttpServletResponse)response).startUpgrade();
                        log.debug("Found a compatible handshake: (Version:" + handshake.getVersion() + "; Handler: " + handshake.getClass().getName() + ")");
                        this.setStandardUpgradeHeaders(response);
                        byte[] handShakeData = handshake.generateResponse(event);
                        event.getHttpServletResponse().getOutputStream().write(handShakeData);
                        WebSocket webSocket = handshake.getWebSocket(event.getHttpServletRequest(), event.getHttpServletResponse(), new ClosingStrategy(){

                            public void doClose() throws IOException {
                                event.close();
                            }
                        });
                        log.debug("Using WebSocket implementation: " + webSocket.getClass().getName());
                        request.setAttribute(SESSION_WEBSOCKET_HANDLE, (Object)webSocket);
                        ((UpgradableHttpServletResponse)response).sendUpgrade();
                        this.onSocketOpened(webSocket);
                    }
                    break;
                }
                throw new IllegalStateException("cannot upgrade connection");
            }
            case END: {
                break;
            }
            case ERROR: {
                event.close();
                break;
            }
            case EVENT: 
            case READ: {
                while (event.isReadReady()) {
                    this.onReceivedFrame((WebSocket)request.getAttribute(SESSION_WEBSOCKET_HANDLE));
                }
                break;
            }
            case TIMEOUT: {
                event.resume();
                break;
            }
            case EOF: {
                this.onSocketClosed((WebSocket)request.getAttribute(SESSION_WEBSOCKET_HANDLE));
            }
        }
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected final long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected final void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected final void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected final void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public final void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    protected void onSocketOpened(WebSocket socket) throws IOException {
    }

    protected void onSocketClosed(WebSocket socket) throws IOException {
    }

    protected void onReceivedFrame(WebSocket socket) throws IOException {
    }

    static {
        log = LoggerFactory.getLogger(WebSocketServlet.class);
        ArrayList<Handshake> handshakeList = new ArrayList<Handshake>();
        handshakeList.add(new Hybi13Handshake());
        handshakeList.add(new Hybi07Handshake());
        handshakeList.add(new Hybi08Handshake());
        handshakeList.add(new Hybi00Handshake());
        websocketHandshakes = Collections.unmodifiableList(handshakeList);
    }
}

