/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class Hash {
    static final String secureRandomAlgorithm = "SHA1PRNG";
    static final String hashAlgorithm = "SHA1";
    static final SecureRandom random;

    private Hash() {
    }

    public static void getRandomBytes(byte[] bytes) {
        random.nextBytes(bytes);
    }

    public static String newUniqueHash() {
        return Hash.nextSecureHash(hashAlgorithm, SecureRandom.getSeed(128));
    }

    private static String nextSecureHash(String algorithm, byte[] additionalSeed) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(String.valueOf(System.nanoTime()).getBytes());
            if (additionalSeed != null) {
                md.update(additionalSeed);
            }
            byte[] randBytes = new byte[64];
            random.nextBytes(randBytes);
            for (int i = 0; i < 1000; ++i) {
                md.update(md.digest());
            }
            return Hash.hashToHexString(md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException("failed to generate session id hash", e);
        }
    }

    private static String hashToHexString(byte[] hash) {
        StringBuilder hexString = new StringBuilder(hash.length);
        for (byte mdbyte : hash) {
            hexString.append(Integer.toHexString(0xFF & mdbyte));
        }
        return hexString.toString();
    }

    static {
        try {
            random = SecureRandom.getInstance(secureRandomAlgorithm);
            random.setSeed(SecureRandom.getInstance(secureRandomAlgorithm).generateSeed(64));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("runtime does not support secure random algorithm: SHA1PRNG");
        }
    }
}

