/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.weld.bootstrap.api.Service;

public class BeanDeploymentModule {
    private final Set<BeanDeploymentArchiveImpl> beanDeploymentArchives;

    public BeanDeploymentModule(Set<BeanDeploymentArchiveImpl> beanDeploymentArchives) {
        this.beanDeploymentArchives = Collections.unmodifiableSet(new HashSet<BeanDeploymentArchiveImpl>(beanDeploymentArchives));
        for (BeanDeploymentArchiveImpl bda : beanDeploymentArchives) {
            bda.addBeanDeploymentArchives(beanDeploymentArchives);
        }
    }

    public synchronized void addBeanDeploymentArchive(BeanDeploymentArchiveImpl archive) {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            bda.addBeanDeploymentArchive(archive);
        }
    }

    public synchronized void addBeanDeploymentModule(BeanDeploymentModule module) {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            bda.addBeanDeploymentArchives(module.beanDeploymentArchives);
        }
    }

    public synchronized void addBeanDeploymentModules(Collection<BeanDeploymentModule> modules) {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            for (BeanDeploymentModule bdm : modules) {
                bda.addBeanDeploymentArchives(bdm.beanDeploymentArchives);
            }
        }
    }

    public synchronized <S extends Service> void addService(Class<S> clazz, S service) {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            bda.getServices().add(clazz, service);
        }
    }

    public Set<BeanDeploymentArchiveImpl> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }
}

