/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.List;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.util.JBossXACMLUtil;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.xacml.core.model.context.ActionType;
import org.jboss.security.xacml.core.model.context.AttributeType;
import org.jboss.security.xacml.core.model.context.EnvironmentType;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResourceType;
import org.jboss.security.xacml.core.model.context.SubjectType;
import org.jboss.security.xacml.factories.RequestAttributeFactory;
import org.jboss.security.xacml.factories.RequestResponseContextFactory;
import org.jboss.security.xacml.interfaces.RequestContext;

public class EJBXACMLUtil
extends JBossXACMLUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestContext createXACMLRequest(String ejbName, Method ejbMethod, Principal principal, RoleGroup callerRoles) throws Exception {
        String action = ejbMethod.getName();
        Class<?>[] paramTypes = ejbMethod.getParameterTypes();
        if (paramTypes.length == 0) {
            return this.createXACMLRequest(ejbName, action, principal, callerRoles);
        }
        StringBuilder builder = new StringBuilder("(");
        int i = 0;
        for (Class<?> paramClass : paramTypes) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(paramClass.getSimpleName());
            ++i;
        }
        builder.append(")");
        ActionType actionType = this.getActionType(action + builder.toString());
        RequestContext requestCtx = this.getRequestContext(ejbName, actionType, principal, callerRoles);
        if (PicketBoxLogger.LOGGER.isDebugEnabled()) {
            ByteArrayOutputStream baos = null;
            try {
                baos = new ByteArrayOutputStream();
                requestCtx.marshall((OutputStream)baos);
                PicketBoxLogger.LOGGER.debug(new String(baos.toByteArray()));
            }
            catch (IOException e) {
            }
            finally {
                this.safeClose(baos);
            }
        }
        return requestCtx;
    }

    public RequestContext createXACMLRequest(String ejbName, String methodName, Principal principal, RoleGroup callerRoles) throws Exception {
        String action = methodName;
        ActionType actionType = this.getActionType(action);
        RequestContext requestCtx = this.getRequestContext(ejbName, actionType, principal, callerRoles);
        if (PicketBoxLogger.LOGGER.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            requestCtx.marshall((OutputStream)baos);
            PicketBoxLogger.LOGGER.debug(new String(baos.toByteArray()));
        }
        return requestCtx;
    }

    private RequestContext getRequestContext(String ejbName, ActionType actionType, Principal principal, RoleGroup callerRoles) throws IOException {
        if (principal == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("principal");
        }
        RequestContext requestCtx = RequestResponseContextFactory.createRequestCtx();
        SubjectType subject = this.getSubjectType(principal, callerRoles);
        ResourceType resourceType = this.getResourceType(ejbName);
        EnvironmentType environmentType = this.getEnvironmentType();
        RequestType requestType = this.getRequestType(subject, resourceType, actionType, environmentType);
        requestCtx.setRequest(requestType);
        return requestCtx;
    }

    private RequestType getRequestType(SubjectType subject, ResourceType resourceType, ActionType actionType, EnvironmentType environmentType) {
        RequestType requestType = new RequestType();
        requestType.getSubject().add(subject);
        requestType.getResource().add(resourceType);
        requestType.setAction(actionType);
        requestType.setEnvironment(environmentType);
        return requestType;
    }

    private EnvironmentType getEnvironmentType() {
        EnvironmentType environmentType = new EnvironmentType();
        environmentType.getAttribute().add(RequestAttributeFactory.createDateTimeAttributeType((String)"urn:oasis:names:tc:xacml:1.0:environment:current-time", null));
        return environmentType;
    }

    private ActionType getActionType(String action) {
        String actionID_NS = "urn:oasis:names:tc:xacml:1.0:action:action-id";
        AttributeType actionAttribute = RequestAttributeFactory.createStringAttributeType((String)actionID_NS, (String)"jboss.org", (String)action);
        ActionType actionType = new ActionType();
        actionType.getAttribute().add(actionAttribute);
        return actionType;
    }

    private ResourceType getResourceType(String ejbName) {
        String resourceID_NS = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
        ResourceType resourceType = new ResourceType();
        AttributeType resourceAttribute = RequestAttributeFactory.createStringAttributeType((String)resourceID_NS, null, (String)ejbName);
        resourceType.getAttribute().add(resourceAttribute);
        return resourceType;
    }

    private SubjectType getSubjectType(Principal principal, RoleGroup callerRoles) {
        String subjectID_NS = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
        String roleID_NS = "urn:oasis:names:tc:xacml:2.0:subject:role";
        String principalName = principal.getName();
        SubjectType subject = new SubjectType();
        AttributeType attribute = RequestAttributeFactory.createStringAttributeType((String)subjectID_NS, (String)"jboss.org", (String)principalName);
        subject.getAttribute().add(attribute);
        List<Role> rolesList = callerRoles.getRoles();
        if (rolesList != null) {
            for (Role role : rolesList) {
                String roleName = role.getRoleName();
                AttributeType attSubjectID = RequestAttributeFactory.createStringAttributeType((String)roleID_NS, (String)"jboss.org", (String)roleName);
                subject.getAttribute().add(attSubjectID);
            }
        }
        return subject;
    }

    private void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

