/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.connector.clustered;

import org.jboss.as.clustering.impl.CoreGroupCommunicationService;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.network.SocketBinding;
import org.jboss.legacy.jnp.JNPLogger;
import org.jboss.legacy.jnp.JNPMessages;
import org.jboss.legacy.jnp.connector.JNPServerNamingConnectorService;
import org.jboss.legacy.jnp.connector.clustered.HAConnectorLegacyService;
import org.jboss.legacy.jnp.connector.clustered.InfinispanGroupCommunicationService;
import org.jboss.legacy.jnp.infinispan.HAGroupCommunicationService;
import org.jboss.legacy.jnp.infinispan.InfinispanDistributedCacheTree;
import org.jboss.legacy.jnp.infinispan.InfinispanDistributedTreeManager;
import org.jboss.legacy.jnp.infinispan.InfinispanHAPartition;
import org.jboss.legacy.jnp.server.NamingStore;
import org.jboss.legacy.jnp.server.NamingStoreAdapter;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HAConnectorService
implements JNPServerNamingConnectorService<HAConnectorLegacyService> {
    private final InjectedValue<InfinispanDistributedTreeManager> distributedTreeManager = new InjectedValue();
    private final InjectedValue<CoreGroupCommunicationService> coreGroupCommunicationService = new InjectedValue();
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final InjectedValue<SocketBinding> rmiBinding = new InjectedValue();
    private final InjectedValue<ServiceBasedNamingStore> namingStoreValue = new InjectedValue();
    private HAConnectorLegacyService service;

    public InjectedValue<InfinispanDistributedTreeManager> getDistributedTreeManager() {
        return this.distributedTreeManager;
    }

    public InjectedValue<CoreGroupCommunicationService> getCoreGroupCommunicationService() {
        return this.coreGroupCommunicationService;
    }

    @Override
    public InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    @Override
    public InjectedValue<SocketBinding> getRmiBinding() {
        return this.rmiBinding;
    }

    public InjectedValue<ServiceBasedNamingStore> getNamingStoreValue() {
        return this.namingStoreValue;
    }

    public HAConnectorLegacyService getValue() throws IllegalStateException, IllegalArgumentException {
        return this.service;
    }

    public void start(StartContext startContext) throws StartException {
        try {
            SocketBinding socketBinding;
            SocketBinding rmiSocketBinding = socketBinding = (SocketBinding)this.getBinding().getValue();
            if (this.getRmiBinding().getOptionalValue() != null) {
                rmiSocketBinding = (SocketBinding)this.getRmiBinding().getValue();
                this.service = new HAConnectorLegacyService((NamingStore)new NamingStoreAdapter((org.jboss.as.naming.NamingStore)this.namingStoreValue.getValue()), (InfinispanDistributedCacheTree)this.distributedTreeManager.getValue(), new InfinispanHAPartition((HAGroupCommunicationService)new InfinispanGroupCommunicationService((CoreGroupCommunicationService)this.coreGroupCommunicationService.getValue())), socketBinding.getAddress().getHostName(), socketBinding.getAbsolutePort(), rmiSocketBinding.getAddress().getHostName(), rmiSocketBinding.getAbsolutePort());
            } else {
                this.service = new HAConnectorLegacyService((NamingStore)new NamingStoreAdapter((org.jboss.as.naming.NamingStore)this.namingStoreValue.getValue()), (InfinispanDistributedCacheTree)this.distributedTreeManager.getValue(), new InfinispanHAPartition((HAGroupCommunicationService)new InfinispanGroupCommunicationService((CoreGroupCommunicationService)this.coreGroupCommunicationService.getValue())), socketBinding.getAddress().getHostName(), socketBinding.getAbsolutePort());
            }
            JNPLogger.ROOT_LOGGER.startHAConnectorService(socketBinding.getName(), socketBinding.getAddress(), socketBinding.getAbsolutePort(), rmiSocketBinding.getName(), rmiSocketBinding.getAddress(), rmiSocketBinding.getAbsolutePort());
            this.service.start();
        }
        catch (Exception e) {
            throw JNPMessages.MESSAGES.failedToStartHAConnectorService(e);
        }
    }

    public void stop(StopContext stopContext) {
        JNPLogger.ROOT_LOGGER.stopHAConnectorService();
        try {
            this.service.stop();
        }
        catch (Exception ex) {
            JNPLogger.ROOT_LOGGER.couldNotStopHAConnectorService(ex);
        }
    }
}

