/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.JSFDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FacesConfigParsingUtil {
    private static final Logger logger = Logger.getLogger(FacesConfigParsingUtil.class);
    private static final JBossEntityResolver jBossJSFEntityResolver = new JBossEntityResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parse(final DeploymentUnit unit, URL facesConfigXmlURL, final JSFDeployment jsfDeployment) throws Exception {
        logger.debug((Object)("Checking for the presence of JSF managed-bean(s) in JSF config file: " + facesConfigXmlURL + " in deployment unit: " + unit));
        SAXParserFactory parserFactory = FacesConfigParsingUtil.getParserFactory();
        SAXParser saxParser = parserFactory.newSAXParser();
        InputStream inputStream = null;
        try {
            inputStream = FacesConfigParsingUtil.getInputStream(facesConfigXmlURL);
            InputSource inputSource = new InputSource(FacesConfigParsingUtil.getInputStream(facesConfigXmlURL));
            inputSource.setSystemId(facesConfigXmlURL.toExternalForm());
            saxParser.parse(inputSource, new DefaultHandler(){
                private boolean managedBeanClassElementProcessingInProgress;

                public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                    InputSource source = jBossJSFEntityResolver.resolveEntity(publicId, systemId);
                    if (source != null) {
                        return source;
                    }
                    return super.resolveEntity(publicId, systemId);
                }

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (localName.equals("managed-bean-class")) {
                        this.managedBeanClassElementProcessingInProgress = true;
                    }
                    super.startElement(uri, localName, qName, attributes);
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (localName.equals("managed-bean-class")) {
                        this.managedBeanClassElementProcessingInProgress = false;
                    }
                    super.endElement(uri, localName, qName);
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    String managedBeanClassName;
                    if (this.managedBeanClassElementProcessingInProgress && !(managedBeanClassName = new String(ch, start, length)).trim().isEmpty()) {
                        logger.debug((Object)("Found JSF managed bean class: " + managedBeanClassName + " in unit " + unit));
                        jsfDeployment.addManagedBean(managedBeanClassName);
                    }
                    super.characters(ch, start, length);
                }
            });
            Object var8_7 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    private static SAXParserFactory getParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory;
    }

    private static InputStream getInputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        return new BufferedInputStream(conn.getInputStream());
    }

    static {
        JBossEntityResolver.registerEntity((String)"-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.0//EN", (String)"web-facesconfig_1_0.dtd");
        JBossEntityResolver.registerEntity((String)"http://java.sun.com/dtd/web-facesconfig_1_0.dtd", (String)"web-facesconfig_1_0.dtd");
        JBossEntityResolver.registerEntity((String)"-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN", (String)"web-facesconfig_1_1.dtd");
        JBossEntityResolver.registerEntity((String)"http://java.sun.com/dtd/web-facesconfig_1_1.dtd", (String)"web-facesconfig_1_1.dtd");
        JBossEntityResolver.registerEntity((String)"http://java.sun.com/xml/ns/j2ee/web-facesconfig_1_2.xsd", (String)"web-facesconfig_1_2.xsd");
    }
}

