/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy;

public abstract class LegacyService {
    public void start() throws Exception {
        ClassLoader old = LegacyService.switchLoader(this.getClass().getClassLoader());
        try {
            this.internalStart();
        }
        finally {
            LegacyService.switchLoader(old);
        }
    }

    public void stop() throws Exception {
        ClassLoader old = LegacyService.switchLoader(this.getClass().getClassLoader());
        try {
            this.internalStop();
        }
        finally {
            LegacyService.switchLoader(old);
        }
    }

    protected abstract void internalStart() throws Exception;

    protected abstract void internalStop() throws Exception;

    public static ClassLoader switchLoader(ClassLoader loader) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        return current;
    }
}

