/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.infinispan;

import java.util.ArrayList;
import java.util.Collection;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.ha.jndi.spi.DistributedTreeManager;
import org.jboss.legacy.jnp.infinispan.InfinispanDistributedCacheTree;
import org.jboss.legacy.jnp.infinispan.PseudoBinding;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingParser;

public class HADistributedTreeManager
implements Naming,
DistributedTreeManager {
    static final long serialVersionUID = 6342802270002172451L;
    private static Logger log = Logger.getLogger(HADistributedTreeManager.class);
    private static final NamingParser parser = new NamingParser();
    private final InfinispanDistributedCacheTree tree;
    private Naming haStub;
    protected boolean acquiredCache = false;

    public HADistributedTreeManager(InfinispanDistributedCacheTree tree) {
        this.tree = tree;
    }

    public void init() {
        this.tree.init();
    }

    public void shutdown() {
        this.tree.shutdown();
    }

    public Naming getHAStub() {
        return this.haStub;
    }

    public void setHAStub(Naming stub) {
        this.haStub = stub;
    }

    public void bind(Name name, Object obj, String className) throws NamingException {
        this.tree.bind(name, obj, className);
    }

    public void rebind(Name name, Object obj, String className) throws NamingException {
        this.tree.rebind(name, obj, className);
    }

    public void unbind(Name name) throws NamingException {
        this.tree.unbind(name);
    }

    public Object lookup(Name name) throws NamingException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("lookup, name=" + name));
        }
        if (name.isEmpty()) {
            return new NamingContext(null, parser.parse(""), this.getHAStub());
        }
        if (this.tree.isContextName(name)) {
            Name fullName = (Name)name.clone();
            return new NamingContext(null, fullName, this.getHAStub());
        }
        return this.tree.lookup(name);
    }

    public Collection<NameClassPair> list(Name name) throws NamingException {
        return this.tree.list(name);
    }

    public Collection<Binding> listBindings(Name name) throws NamingException {
        Collection<PseudoBinding> pseudos = this.tree.listBindings(name);
        ArrayList<Binding> bindings = new ArrayList<Binding>(pseudos.size());
        for (PseudoBinding pseudo : pseudos) {
            if (pseudo.isBinding()) {
                bindings.add(pseudo.getBinding());
                continue;
            }
            NamingContext subCtx = new NamingContext(null, pseudo.getFullName(), this.getHAStub());
            bindings.add(new Binding(pseudo.getChild(), NamingContext.class.getName(), subCtx, true));
        }
        return bindings;
    }

    public Context createSubcontext(Name name) throws NamingException {
        this.tree.createSubcontext(name);
        Name fullName = parser.parse("");
        fullName.addAll(name);
        return new NamingContext(null, fullName, this.getHAStub());
    }
}

