/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence.deployer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;

public class PersistenceModificationChecker {
    private static final Logger log = Logger.getLogger(PersistenceModificationChecker.class);
    private static FileFilter filter = new ExcludeFilter();

    public static boolean hasBeenModified(VFSDeploymentUnit unit, long lastModified) throws Exception {
        File file = new File(unit.getRoot().toURL().getPath());
        if (!file.exists()) {
            if (!unit.isTopLevel()) {
                return false;
            }
            throw new IllegalStateException("deployment file does not exist " + file);
        }
        if (file.isFile()) {
            log.info((Object)(file + " " + file.lastModified() + " // " + lastModified));
            return file.lastModified() > lastModified;
        }
        StructureMetaData structureMetaData = (StructureMetaData)unit.getAttachment(StructureMetaData.class);
        if (structureMetaData == null) {
            return false;
        }
        ContextInfo info = structureMetaData.getContext(unit.getSimpleName());
        if (info == null && unit.isTopLevel()) {
            info = structureMetaData.getContext("");
        }
        if (info == null) {
            return false;
        }
        return PersistenceModificationChecker.hasBeenModifed(file, info, lastModified);
    }

    protected static boolean hasBeenModifed(File root, ContextInfo contextInfo, long lastModified) throws IOException {
        List metadataPaths = contextInfo.getMetaDataPath();
        if (metadataPaths != null && !metadataPaths.isEmpty()) {
            for (String metaDataPath : metadataPaths) {
                File[] children;
                File mdpVF = new File(root, metaDataPath);
                if (mdpVF == null || (children = mdpVF.listFiles(filter)) == null || children.length <= 0) continue;
                for (File child : children) {
                    if (child.lastModified() <= lastModified) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Metadata location modified: " + child));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected static class ExcludeFilter
    implements FileFilter {
        protected ExcludeFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".xml");
        }
    }
}

