/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.system.server.profile.repository.AbstractImmutableProfile;
import org.jboss.system.server.profile.repository.metadata.FilteredProfileMetaData;
import org.jboss.system.server.profileservice.repository.AbstractProfileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredProfileFactory
extends AbstractProfileFactory
implements ProfileFactory {
    public static final Collection<String> types = Arrays.asList(FilteredProfileMetaData.class.getName());

    public String[] getTypes() {
        return types.toArray(new String[types.size()]);
    }

    @Override
    public Profile createProfile(ProfileKey key, ProfileMetaData metaData, List<ProfileKey> subProfiles) throws URISyntaxException {
        return new AbstractImmutableProfile(key, this.createURIs(metaData), subProfiles);
    }

    protected URI[] createURIs(ProfileMetaData metaData) throws URISyntaxException {
        ProfileSourceMetaData profileSource = metaData.getSource();
        if (profileSource == null) {
            throw new IllegalArgumentException("Null profile source.");
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String source : profileSource.getSources()) {
            URI uri = new URI(source);
            uris.add(uri);
        }
        return uris.toArray(new URI[uris.size()]);
    }
}

